/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.util.automaton;

import java.util.Arrays;
import org.neo4j.shaded.lucene9.internal.hppc.IntArrayList;
import org.neo4j.shaded.lucene9.util.automaton.Automaton;
import org.neo4j.shaded.lucene9.util.automaton.Transition;

public final class UTF32ToUTF8 {
    private static final int[] startCodes = new int[]{0, 128, 2048, 65536};
    private static final int[] endCodes = new int[]{127, 2047, 65535, 0x10FFFF};
    static byte[] MASKS = new byte[8];
    private final UTF8Sequence startUTF8 = new UTF8Sequence();
    private final UTF8Sequence endUTF8 = new UTF8Sequence();
    private final UTF8Sequence tmpUTF8a = new UTF8Sequence();
    private final UTF8Sequence tmpUTF8b = new UTF8Sequence();
    Automaton.Builder utf8;

    void convertOneEdge(int start, int end, int startCodePoint, int endCodePoint) {
        this.startUTF8.set(startCodePoint);
        this.endUTF8.set(endCodePoint);
        this.build(start, end, this.startUTF8, this.endUTF8, 0);
    }

    private void build(int start, int end, UTF8Sequence startUTF8, UTF8Sequence endUTF8, int upto) {
        if (startUTF8.byteAt(upto) == endUTF8.byteAt(upto)) {
            if (upto == startUTF8.len - 1 && upto == endUTF8.len - 1) {
                this.utf8.addTransition(start, end, startUTF8.byteAt(upto), endUTF8.byteAt(upto));
                return;
            }
            assert (startUTF8.len > upto + 1);
            assert (endUTF8.len > upto + 1);
            int n = this.utf8.createState();
            this.utf8.addTransition(start, n, startUTF8.byteAt(upto));
            this.build(n, end, startUTF8, endUTF8, 1 + upto);
        } else if (startUTF8.len == endUTF8.len) {
            if (upto == startUTF8.len - 1) {
                this.utf8.addTransition(start, end, startUTF8.byteAt(upto), endUTF8.byteAt(upto));
            } else {
                this.start(start, end, startUTF8, upto, false);
                if (endUTF8.byteAt(upto) - startUTF8.byteAt(upto) > 1) {
                    this.all(start, end, startUTF8.byteAt(upto) + 1, endUTF8.byteAt(upto) - 1, startUTF8.len - upto - 1);
                }
                this.end(start, end, endUTF8, upto, false);
            }
        } else {
            this.start(start, end, startUTF8, upto, true);
            int limit = endUTF8.len - upto;
            for (int byteCount = 1 + startUTF8.len - upto; byteCount < limit; ++byteCount) {
                this.tmpUTF8a.setFirstByte(startCodes[byteCount - 1]);
                this.tmpUTF8b.setFirstByte(endCodes[byteCount - 1]);
                this.all(start, end, this.tmpUTF8a.byteAt(0), this.tmpUTF8b.byteAt(0), this.tmpUTF8a.len - 1);
            }
            this.end(start, end, endUTF8, upto, true);
        }
    }

    private void start(int start, int end, UTF8Sequence startUTF8, int upto, boolean doAll) {
        if (upto == startUTF8.len - 1) {
            this.utf8.addTransition(start, end, startUTF8.byteAt(upto), startUTF8.byteAt(upto) | MASKS[startUTF8.numBits(upto)]);
        } else {
            int n = this.utf8.createState();
            this.utf8.addTransition(start, n, startUTF8.byteAt(upto));
            this.start(n, end, startUTF8, 1 + upto, true);
            int endCode = startUTF8.byteAt(upto) | MASKS[startUTF8.numBits(upto)];
            if (doAll && startUTF8.byteAt(upto) != endCode) {
                this.all(start, end, startUTF8.byteAt(upto) + 1, endCode, startUTF8.len - upto - 1);
            }
        }
    }

    private void end(int start, int end, UTF8Sequence endUTF8, int upto, boolean doAll) {
        if (upto == endUTF8.len - 1) {
            this.utf8.addTransition(start, end, endUTF8.byteAt(upto) & ~MASKS[endUTF8.numBits(upto)], endUTF8.byteAt(upto));
        } else {
            int startCode;
            if (endUTF8.len == 2) {
                assert (upto == 0);
                startCode = 194;
            } else {
                startCode = endUTF8.len == 3 && upto == 1 && endUTF8.byteAt(0) == 224 ? 160 : (endUTF8.len == 4 && upto == 1 && endUTF8.byteAt(0) == 240 ? 144 : endUTF8.byteAt(upto) & ~MASKS[endUTF8.numBits(upto)]);
            }
            if (doAll && endUTF8.byteAt(upto) != startCode) {
                this.all(start, end, startCode, endUTF8.byteAt(upto) - 1, endUTF8.len - upto - 1);
            }
            int n = this.utf8.createState();
            this.utf8.addTransition(start, n, endUTF8.byteAt(upto));
            this.end(n, end, endUTF8, 1 + upto, true);
        }
    }

    private void all(int start, int end, int startCode, int endCode, int left) {
        if (left == 0) {
            this.utf8.addTransition(start, end, startCode, endCode);
        } else {
            int lastN = this.utf8.createState();
            this.utf8.addTransition(start, lastN, startCode, endCode);
            while (left > 1) {
                int n = this.utf8.createState();
                this.utf8.addTransition(lastN, n, 128, 191);
                --left;
                lastN = n;
            }
            this.utf8.addTransition(lastN, end, 128, 191);
        }
    }

    public Automaton convert(Automaton utf32) {
        if (utf32.getNumStates() == 0) {
            return utf32;
        }
        int[] map = new int[utf32.getNumStates()];
        Arrays.fill(map, -1);
        IntArrayList pending = new IntArrayList();
        int utf32State = 0;
        pending.add(utf32State);
        this.utf8 = new Automaton.Builder();
        int utf8State = this.utf8.createState();
        this.utf8.setAccept(utf8State, utf32.isAccept(utf32State));
        map[utf32State] = utf8State;
        Transition scratch = new Transition();
        while (pending.size() != 0) {
            utf32State = pending.removeLast();
            utf8State = map[utf32State];
            assert (utf8State != -1);
            int numTransitions = utf32.getNumTransitions(utf32State);
            utf32.initTransition(utf32State, scratch);
            for (int i = 0; i < numTransitions; ++i) {
                utf32.getNextTransition(scratch);
                int destUTF32 = scratch.dest;
                int destUTF8 = map[destUTF32];
                if (destUTF8 == -1) {
                    destUTF8 = this.utf8.createState();
                    this.utf8.setAccept(destUTF8, utf32.isAccept(destUTF32));
                    map[destUTF32] = destUTF8;
                    pending.add(destUTF32);
                }
                this.convertOneEdge(utf8State, destUTF8, scratch.min, scratch.max);
            }
        }
        return this.utf8.finish();
    }

    static {
        for (int i = 0; i < 7; ++i) {
            UTF32ToUTF8.MASKS[i + 1] = (byte)((2 << i) - 1);
        }
    }

    private static class UTF8Sequence {
        private final UTF8Byte[] bytes = new UTF8Byte[4];
        private int len;

        public UTF8Sequence() {
            for (int i = 0; i < 4; ++i) {
                this.bytes[i] = new UTF8Byte();
            }
        }

        public int byteAt(int idx) {
            return this.bytes[idx].value & 0xFF;
        }

        public int numBits(int idx) {
            return this.bytes[idx].bits;
        }

        private void set(int code) {
            if (code < 128) {
                this.bytes[0].value = (byte)code;
                this.bytes[0].bits = (byte)7;
                this.len = 1;
            } else if (code < 2048) {
                this.bytes[0].value = (byte)(0xC0 | code >> 6);
                this.bytes[0].bits = (byte)5;
                this.setRest(code, 1);
                this.len = 2;
            } else if (code < 65536) {
                this.bytes[0].value = (byte)(0xE0 | code >> 12);
                this.bytes[0].bits = (byte)4;
                this.setRest(code, 2);
                this.len = 3;
            } else {
                this.bytes[0].value = (byte)(0xF0 | code >> 18);
                this.bytes[0].bits = (byte)3;
                this.setRest(code, 3);
                this.len = 4;
            }
        }

        private void setFirstByte(int code) {
            if (code < 128) {
                this.bytes[0].value = (byte)code;
                this.len = 1;
            } else if (code < 2048) {
                this.bytes[0].value = (byte)(0xC0 | code >> 6);
                this.len = 2;
            } else if (code < 65536) {
                this.bytes[0].value = (byte)(0xE0 | code >> 12);
                this.len = 3;
            } else {
                this.bytes[0].value = (byte)(0xF0 | code >> 18);
                this.len = 4;
            }
        }

        private void setRest(int code, int numBytes) {
            for (int i = 0; i < numBytes; ++i) {
                this.bytes[numBytes - i].value = (byte)(0x80 | code & MASKS[6]);
                this.bytes[numBytes - i].bits = (byte)6;
                code >>= 6;
            }
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < this.len; ++i) {
                if (i > 0) {
                    b.append(' ');
                }
                b.append(Integer.toBinaryString(this.byteAt(i)));
            }
            return b.toString();
        }
    }

    private static class UTF8Byte {
        byte value;
        byte bits;

        private UTF8Byte() {
        }
    }
}

