/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.util.automaton;

import java.io.IOException;
import org.neo4j.shaded.lucene9.index.SingleTermsEnum;
import org.neo4j.shaded.lucene9.index.Term;
import org.neo4j.shaded.lucene9.index.Terms;
import org.neo4j.shaded.lucene9.index.TermsEnum;
import org.neo4j.shaded.lucene9.internal.hppc.IntArrayList;
import org.neo4j.shaded.lucene9.search.Query;
import org.neo4j.shaded.lucene9.search.QueryVisitor;
import org.neo4j.shaded.lucene9.util.Accountable;
import org.neo4j.shaded.lucene9.util.BytesRef;
import org.neo4j.shaded.lucene9.util.BytesRefBuilder;
import org.neo4j.shaded.lucene9.util.IntsRef;
import org.neo4j.shaded.lucene9.util.RamUsageEstimator;
import org.neo4j.shaded.lucene9.util.StringHelper;
import org.neo4j.shaded.lucene9.util.UnicodeUtil;
import org.neo4j.shaded.lucene9.util.automaton.Automata;
import org.neo4j.shaded.lucene9.util.automaton.Automaton;
import org.neo4j.shaded.lucene9.util.automaton.ByteRunAutomaton;
import org.neo4j.shaded.lucene9.util.automaton.Operations;
import org.neo4j.shaded.lucene9.util.automaton.Transition;
import org.neo4j.shaded.lucene9.util.automaton.UTF32ToUTF8;

public class CompiledAutomaton
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(CompiledAutomaton.class);
    public final AUTOMATON_TYPE type;
    public final BytesRef term;
    public final ByteRunAutomaton runAutomaton;
    public final Automaton automaton;
    public final BytesRef commonSuffixRef;
    public final Boolean finite;
    public final int sinkState;
    private Transition transition = new Transition();

    public CompiledAutomaton(Automaton automaton) {
        this(automaton, null, true);
    }

    private static int findSinkState(Automaton automaton) {
        int numStates = automaton.getNumStates();
        Transition t = new Transition();
        int foundState = -1;
        for (int s = 0; s < numStates; ++s) {
            if (!automaton.isAccept(s)) continue;
            int count = automaton.initTransition(s, t);
            boolean isSinkState = false;
            for (int i = 0; i < count; ++i) {
                automaton.getNextTransition(t);
                if (t.dest != s || t.min != 0 || t.max != 255) continue;
                isSinkState = true;
                break;
            }
            if (!isSinkState) continue;
            foundState = s;
            break;
        }
        return foundState;
    }

    public CompiledAutomaton(Automaton automaton, Boolean finite, boolean simplify) {
        this(automaton, finite, simplify, 10000, false);
    }

    public CompiledAutomaton(Automaton automaton, Boolean finite, boolean simplify, int determinizeWorkLimit, boolean isBinary) {
        if (automaton.getNumStates() == 0) {
            automaton = new Automaton();
            automaton.createState();
        }
        if (simplify) {
            if (Operations.isEmpty(automaton)) {
                this.type = AUTOMATON_TYPE.NONE;
                this.term = null;
                this.commonSuffixRef = null;
                this.runAutomaton = null;
                this.automaton = null;
                this.finite = null;
                this.sinkState = -1;
                return;
            }
            boolean isTotal = isBinary ? Operations.isTotal(automaton, 0, 255) : Operations.isTotal(automaton);
            if (isTotal) {
                this.type = AUTOMATON_TYPE.ALL;
                this.term = null;
                this.commonSuffixRef = null;
                this.runAutomaton = null;
                this.automaton = null;
                this.finite = null;
                this.sinkState = -1;
                return;
            }
            IntsRef singleton = Operations.getSingleton(automaton = Operations.determinize(automaton, determinizeWorkLimit));
            if (singleton != null) {
                this.type = AUTOMATON_TYPE.SINGLE;
                this.commonSuffixRef = null;
                this.runAutomaton = null;
                this.automaton = null;
                this.finite = null;
                this.term = isBinary ? StringHelper.intsRefToBytesRef(singleton) : new BytesRef(UnicodeUtil.newString(singleton.ints, singleton.offset, singleton.length));
                this.sinkState = -1;
                return;
            }
        }
        this.type = AUTOMATON_TYPE.NORMAL;
        this.term = null;
        this.finite = finite == null ? Boolean.valueOf(Operations.isFinite(automaton)) : finite;
        Automaton binary = isBinary ? automaton : new UTF32ToUTF8().convert(automaton);
        if (this.finite.booleanValue() || automaton.getNumStates() + automaton.getNumTransitions() > 1000) {
            this.commonSuffixRef = null;
        } else {
            BytesRef suffix = Operations.getCommonSuffixBytesRef(binary);
            this.commonSuffixRef = suffix.length == 0 ? null : suffix;
        }
        this.runAutomaton = new ByteRunAutomaton(binary, true, determinizeWorkLimit);
        this.automaton = this.runAutomaton.automaton;
        this.sinkState = CompiledAutomaton.findSinkState(this.automaton);
    }

    private BytesRef addTail(int state, BytesRefBuilder term, int idx, int leadLabel) {
        int maxIndex = -1;
        int numTransitions = this.automaton.initTransition(state, this.transition);
        int i = 0;
        while (i < numTransitions) {
            this.automaton.getNextTransition(this.transition);
            if (this.transition.min >= leadLabel) break;
            maxIndex = i++;
        }
        assert (maxIndex != -1);
        this.automaton.getTransition(state, maxIndex, this.transition);
        int floorLabel = this.transition.max > leadLabel - 1 ? leadLabel - 1 : this.transition.max;
        term.grow(1 + idx);
        term.setByteAt(idx, (byte)floorLabel);
        state = this.transition.dest;
        ++idx;
        while (true) {
            if ((numTransitions = this.automaton.getNumTransitions(state)) == 0) {
                assert (this.runAutomaton.isAccept(state));
                term.setLength(idx);
                return term.get();
            }
            this.automaton.getTransition(state, numTransitions - 1, this.transition);
            term.grow(1 + idx);
            term.setByteAt(idx, (byte)this.transition.max);
            state = this.transition.dest;
            ++idx;
        }
    }

    public TermsEnum getTermsEnum(Terms terms) throws IOException {
        switch (this.type) {
            case NONE: {
                return TermsEnum.EMPTY;
            }
            case ALL: {
                return terms.iterator();
            }
            case SINGLE: {
                return new SingleTermsEnum(terms.iterator(), this.term);
            }
            case NORMAL: {
                return terms.intersect(this, null);
            }
        }
        throw new RuntimeException("unhandled case");
    }

    public void visit(QueryVisitor visitor, Query parent, String field) {
        if (visitor.acceptField(field)) {
            switch (this.type) {
                case NORMAL: {
                    visitor.consumeTermsMatching(parent, field, () -> this.runAutomaton);
                    break;
                }
                case NONE: {
                    break;
                }
                case ALL: {
                    visitor.consumeTermsMatching(parent, field, () -> new ByteRunAutomaton(Automata.makeAnyString()));
                    break;
                }
                case SINGLE: {
                    visitor.consumeTerms(parent, new Term(field, this.term));
                }
            }
        }
    }

    public BytesRef floor(BytesRef input, BytesRefBuilder output) {
        int state = 0;
        if (input.length == 0) {
            if (this.runAutomaton.isAccept(state)) {
                output.clear();
                return output.get();
            }
            return null;
        }
        IntArrayList stack = new IntArrayList();
        int idx = 0;
        while (true) {
            int label = input.bytes[input.offset + idx] & 0xFF;
            int nextState = this.runAutomaton.step(state, label);
            if (idx == input.length - 1) {
                if (nextState != -1 && this.runAutomaton.isAccept(nextState)) {
                    output.grow(1 + idx);
                    output.setByteAt(idx, (byte)label);
                    output.setLength(input.length);
                    return output.get();
                }
                nextState = -1;
            }
            if (nextState == -1) {
                while (true) {
                    int numTransitions;
                    if ((numTransitions = this.automaton.getNumTransitions(state)) == 0) {
                        assert (this.runAutomaton.isAccept(state));
                        output.setLength(idx);
                        return output.get();
                    }
                    this.automaton.getTransition(state, 0, this.transition);
                    if (label - 1 >= this.transition.min) break;
                    if (this.runAutomaton.isAccept(state)) {
                        output.setLength(idx);
                        return output.get();
                    }
                    if (stack.size() == 0) {
                        return null;
                    }
                    state = stack.removeLast();
                    label = input.bytes[input.offset + --idx] & 0xFF;
                }
                return this.addTail(state, output, idx, label);
            }
            output.grow(1 + idx);
            output.setByteAt(idx, (byte)label);
            stack.add(state);
            state = nextState;
            ++idx;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.runAutomaton == null ? 0 : this.runAutomaton.hashCode());
        result = 31 * result + (this.term == null ? 0 : this.term.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompiledAutomaton other = (CompiledAutomaton)obj;
        if (this.type != other.type) {
            return false;
        }
        return !(this.type == AUTOMATON_TYPE.SINGLE ? !this.term.equals(other.term) : this.type == AUTOMATON_TYPE.NORMAL && !this.runAutomaton.equals(other.runAutomaton));
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject(this.automaton) + RamUsageEstimator.sizeOfObject(this.commonSuffixRef) + RamUsageEstimator.sizeOfObject(this.runAutomaton) + RamUsageEstimator.sizeOfObject(this.term) + RamUsageEstimator.sizeOfObject(this.transition);
    }

    public static enum AUTOMATON_TYPE {
        NONE,
        ALL,
        SINGLE,
        NORMAL;

    }
}

