/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.util;

import java.util.Arrays;
import org.neo4j.shaded.lucene9.util.Accountable;
import org.neo4j.shaded.lucene9.util.BitUtil;
import org.neo4j.shaded.lucene9.util.ByteBlockPool;
import org.neo4j.shaded.lucene9.util.BytesRef;
import org.neo4j.shaded.lucene9.util.BytesRefHash;
import org.neo4j.shaded.lucene9.util.RamUsageEstimator;

public class BytesRefBlockPool
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(BytesRefBlockPool.class);
    private final ByteBlockPool byteBlockPool;

    public BytesRefBlockPool() {
        this.byteBlockPool = new ByteBlockPool(new ByteBlockPool.DirectAllocator());
    }

    public BytesRefBlockPool(ByteBlockPool byteBlockPool) {
        this.byteBlockPool = byteBlockPool;
    }

    void reset() {
        this.byteBlockPool.reset(false, false);
    }

    public void fillBytesRef(BytesRef term, int start) {
        int pos;
        term.bytes = this.byteBlockPool.getBuffer(start >> 15);
        byte[] bytes = term.bytes;
        if ((bytes[pos = start & Short.MAX_VALUE] & 0x80) == 0) {
            term.length = bytes[pos];
            term.offset = pos + 1;
        } else {
            term.length = BitUtil.VH_BE_SHORT.get(bytes, pos) & Short.MAX_VALUE;
            term.offset = pos + 2;
        }
        assert (term.length >= 0);
    }

    public int addBytesRef(BytesRef bytes) {
        int length = bytes.length;
        int len2 = 2 + bytes.length;
        if (len2 + this.byteBlockPool.byteUpto > 32768) {
            if (len2 > 32768) {
                throw new BytesRefHash.MaxBytesLengthExceededException("bytes can be at most 32766 in length; got " + bytes.length);
            }
            this.byteBlockPool.nextBuffer();
        }
        byte[] buffer = this.byteBlockPool.buffer;
        int bufferUpto = this.byteBlockPool.byteUpto;
        int textStart = bufferUpto + this.byteBlockPool.byteOffset;
        if (length < 128) {
            buffer[bufferUpto] = (byte)length;
            this.byteBlockPool.byteUpto += length + 1;
            assert (length >= 0) : "Length must be positive: " + length;
            System.arraycopy(bytes.bytes, bytes.offset, buffer, bufferUpto + 1, length);
        } else {
            BitUtil.VH_BE_SHORT.set(buffer, bufferUpto, (short)(length | 0x8000));
            this.byteBlockPool.byteUpto += length + 2;
            System.arraycopy(bytes.bytes, bytes.offset, buffer, bufferUpto + 2, length);
        }
        return textStart;
    }

    int hash(int start) {
        int pos;
        int len;
        int offset = start & Short.MAX_VALUE;
        byte[] bytes = this.byteBlockPool.getBuffer(start >> 15);
        if ((bytes[offset] & 0x80) == 0) {
            len = bytes[offset];
            pos = offset + 1;
        } else {
            len = BitUtil.VH_BE_SHORT.get(bytes, offset) & Short.MAX_VALUE;
            pos = offset + 2;
        }
        return BytesRefHash.doHash(bytes, pos, len);
    }

    boolean equals(int start, BytesRef b) {
        int offset;
        int length;
        int pos;
        byte[] bytes = this.byteBlockPool.getBuffer(start >> 15);
        if ((bytes[pos = start & Short.MAX_VALUE] & 0x80) == 0) {
            length = bytes[pos];
            offset = pos + 1;
        } else {
            length = BitUtil.VH_BE_SHORT.get(bytes, pos) & Short.MAX_VALUE;
            offset = pos + 2;
        }
        return Arrays.equals(bytes, offset, offset + length, b.bytes, b.offset, b.offset + b.length);
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES + this.byteBlockPool.ramBytesUsed();
    }
}

