/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.store;

import java.io.IOException;
import java.util.HashSet;
import org.neo4j.shaded.lucene9.store.AlreadyClosedException;
import org.neo4j.shaded.lucene9.store.Directory;
import org.neo4j.shaded.lucene9.store.Lock;
import org.neo4j.shaded.lucene9.store.LockFactory;
import org.neo4j.shaded.lucene9.store.LockObtainFailedException;

public final class SingleInstanceLockFactory
extends LockFactory {
    final HashSet<String> locks = new HashSet();

    @Override
    public Lock obtainLock(Directory dir, String lockName) throws IOException {
        HashSet<String> hashSet = this.locks;
        synchronized (hashSet) {
            if (this.locks.add(lockName)) {
                return new SingleInstanceLock(lockName);
            }
            throw new LockObtainFailedException("lock instance already obtained: (dir=" + dir + ", lockName=" + lockName + ")");
        }
    }

    private class SingleInstanceLock
    extends Lock {
        private final String lockName;
        private volatile boolean closed;

        public SingleInstanceLock(String lockName) {
            this.lockName = lockName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ensureValid() throws IOException {
            if (this.closed) {
                throw new AlreadyClosedException("Lock instance already released: " + this);
            }
            HashSet<String> hashSet = SingleInstanceLockFactory.this.locks;
            synchronized (hashSet) {
                if (!SingleInstanceLockFactory.this.locks.contains(this.lockName)) {
                    throw new AlreadyClosedException("Lock instance was invalidated from map: " + this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                HashSet<String> hashSet = SingleInstanceLockFactory.this.locks;
                synchronized (hashSet) {
                    if (!SingleInstanceLockFactory.this.locks.remove(this.lockName)) {
                        throw new AlreadyClosedException("Lock was already released: " + this);
                    }
                }
            }
            finally {
                this.closed = true;
            }
        }

        public String toString() {
            return super.toString() + ": " + this.lockName;
        }
    }
}

