/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search.similarities;

import java.util.Collections;
import org.neo4j.shaded.lucene9.index.FieldInvertState;
import org.neo4j.shaded.lucene9.index.IndexOptions;
import org.neo4j.shaded.lucene9.search.CollectionStatistics;
import org.neo4j.shaded.lucene9.search.Explanation;
import org.neo4j.shaded.lucene9.search.TermStatistics;
import org.neo4j.shaded.lucene9.util.SmallFloat;

public abstract class Similarity {
    private final boolean discountOverlaps;

    public final boolean getDiscountOverlaps() {
        return this.discountOverlaps;
    }

    protected Similarity() {
        this(true);
    }

    protected Similarity(boolean discountOverlaps) {
        this.discountOverlaps = discountOverlaps;
    }

    public long computeNorm(FieldInvertState state) {
        int numTerms = state.getIndexOptions() == IndexOptions.DOCS ? state.getUniqueTermCount() : (this.discountOverlaps ? state.getLength() - state.getNumOverlap() : state.getLength());
        return SmallFloat.intToByte4(numTerms);
    }

    public abstract SimScorer scorer(float var1, CollectionStatistics var2, TermStatistics ... var3);

    public static abstract class SimScorer {
        protected SimScorer() {
        }

        public abstract float score(float var1, long var2);

        public Explanation explain(Explanation freq, long norm) {
            return Explanation.match((Number)Float.valueOf(this.score(freq.getValue().floatValue(), norm)), "score(freq=" + freq.getValue() + "), with freq of:", Collections.singleton(freq));
        }
    }
}

