/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search.comparators;

import java.io.IOException;
import org.neo4j.shaded.lucene9.search.DocIdSetIterator;

public class MinDocIterator
extends DocIdSetIterator {
    final int segmentMinDoc;
    final int maxDoc;
    int doc = -1;

    MinDocIterator(int segmentMinDoc, int maxDoc) {
        this.segmentMinDoc = segmentMinDoc;
        this.maxDoc = maxDoc;
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public int nextDoc() throws IOException {
        return this.advance(this.doc + 1);
    }

    @Override
    public int advance(int target) throws IOException {
        assert (target > this.doc);
        this.doc = this.doc == -1 ? Math.max(target, this.segmentMinDoc) : target;
        if (this.doc >= this.maxDoc) {
            this.doc = Integer.MAX_VALUE;
        }
        return this.doc;
    }

    @Override
    public long cost() {
        return this.maxDoc - this.segmentMinDoc;
    }
}

