/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search;

import java.io.IOException;
import org.neo4j.shaded.lucene9.index.LeafReaderContext;
import org.neo4j.shaded.lucene9.search.DocIdSetIterator;
import org.neo4j.shaded.lucene9.search.DoubleValues;
import org.neo4j.shaded.lucene9.search.DoubleValuesSource;
import org.neo4j.shaded.lucene9.search.IndexSearcher;
import org.neo4j.shaded.lucene9.search.VectorScorer;

abstract class VectorSimilarityValuesSource
extends DoubleValuesSource {
    protected final String fieldName;

    public VectorSimilarityValuesSource(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
        final VectorScorer scorer = this.getScorer(ctx);
        if (scorer == null) {
            return DoubleValues.EMPTY;
        }
        final DocIdSetIterator iterator = scorer.iterator();
        return new DoubleValues(){

            @Override
            public double doubleValue() throws IOException {
                return scorer.score();
            }

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return doc >= iterator.docID() && (iterator.docID() == doc || iterator.advance(doc) == doc);
            }
        };
    }

    protected abstract VectorScorer getScorer(LeafReaderContext var1) throws IOException;

    @Override
    public boolean needsScores() {
        return false;
    }

    @Override
    public DoubleValuesSource rewrite(IndexSearcher reader) throws IOException {
        return this;
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        return true;
    }
}

