/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search;

import java.util.Objects;
import org.neo4j.shaded.lucene9.index.Term;
import org.neo4j.shaded.lucene9.util.BytesRef;

public class TermStatistics {
    private final BytesRef term;
    private final long docFreq;
    private final long totalTermFreq;

    public TermStatistics(BytesRef term, long docFreq, long totalTermFreq) {
        Objects.requireNonNull(term);
        if (docFreq <= 0L) {
            throw new IllegalArgumentException("docFreq must be positive, docFreq: " + docFreq);
        }
        if (totalTermFreq <= 0L) {
            throw new IllegalArgumentException("totalTermFreq must be positive, totalTermFreq: " + totalTermFreq);
        }
        if (totalTermFreq < docFreq) {
            throw new IllegalArgumentException("totalTermFreq must be at least docFreq, totalTermFreq: " + totalTermFreq + ", docFreq: " + docFreq);
        }
        this.term = term;
        this.docFreq = docFreq;
        this.totalTermFreq = totalTermFreq;
    }

    public final BytesRef term() {
        return this.term;
    }

    public final long docFreq() {
        return this.docFreq;
    }

    public final long totalTermFreq() {
        return this.totalTermFreq;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("term=");
        sb.append('\"');
        sb.append(Term.toString(this.term()));
        sb.append('\"');
        sb.append(",docFreq=");
        sb.append(this.docFreq());
        sb.append(",totalTermFreq=");
        sb.append(this.totalTermFreq());
        return sb.toString();
    }
}

