/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search;

import java.util.Objects;
import java.util.concurrent.atomic.LongAccumulator;

final class MaxScoreAccumulator {
    static final int DEFAULT_INTERVAL = 1023;
    final LongAccumulator acc = new LongAccumulator(MaxScoreAccumulator::maxEncode, Long.MIN_VALUE);
    long modInterval = 1023L;

    MaxScoreAccumulator() {
    }

    private static long maxEncode(long v1, long v2) {
        float score2;
        float score1 = Float.intBitsToFloat((int)(v1 >> 32));
        int cmp = Float.compare(score1, score2 = Float.intBitsToFloat((int)(v2 >> 32)));
        if (cmp == 0) {
            return (int)v1 < (int)v2 ? v1 : v2;
        }
        if (cmp > 0) {
            return v1;
        }
        return v2;
    }

    void accumulate(int docBase, float score) {
        assert (docBase >= 0 && score >= 0.0f);
        long encode = (long)Float.floatToIntBits(score) << 32 | (long)docBase;
        this.acc.accumulate(encode);
    }

    DocAndScore get() {
        long value = this.acc.get();
        if (value == Long.MIN_VALUE) {
            return null;
        }
        float score = Float.intBitsToFloat((int)(value >> 32));
        int docBase = (int)value;
        return new DocAndScore(docBase, score);
    }

    static class DocAndScore
    implements Comparable<DocAndScore> {
        final int docBase;
        final float score;

        DocAndScore(int docBase, float score) {
            this.docBase = docBase;
            this.score = score;
        }

        @Override
        public int compareTo(DocAndScore o) {
            int cmp = Float.compare(this.score, o.score);
            if (cmp == 0) {
                return Integer.compare(o.docBase, this.docBase);
            }
            return cmp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DocAndScore result = (DocAndScore)o;
            return this.docBase == result.docBase && Float.compare(result.score, this.score) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.docBase, Float.valueOf(this.score));
        }

        public String toString() {
            return "DocAndScore{docBase=" + this.docBase + ", score=" + this.score + "}";
        }
    }
}

