/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.neo4j.shaded.lucene9.search.BooleanClause;
import org.neo4j.shaded.lucene9.search.BooleanQuery;
import org.neo4j.shaded.lucene9.search.IndexSearcher;
import org.neo4j.shaded.lucene9.search.Query;
import org.neo4j.shaded.lucene9.search.QueryVisitor;
import org.neo4j.shaded.lucene9.search.ScoreMode;
import org.neo4j.shaded.lucene9.search.Weight;

public abstract class IndriQuery
extends Query
implements Iterable<BooleanClause> {
    private List<BooleanClause> clauses;

    public IndriQuery(List<BooleanClause> clauses) {
        this.clauses = clauses;
    }

    @Override
    public abstract Weight createWeight(IndexSearcher var1, ScoreMode var2, float var3) throws IOException;

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        for (BooleanClause c : this) {
            buffer.append(c.getOccur().toString());
            Query subQuery = c.getQuery();
            if (subQuery instanceof BooleanQuery) {
                buffer.append("(");
                buffer.append(subQuery.toString(field));
                buffer.append(")");
            } else {
                buffer.append(subQuery.toString(field));
            }
            if (i != this.clauses.size() - 1) {
                buffer.append(" ");
            }
            ++i;
        }
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo((IndriQuery)this.getClass().cast(o));
    }

    @Override
    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf(this);
    }

    private boolean equalsTo(IndriQuery other) {
        return this.clauses.equals(other.clauses);
    }

    @Override
    public int hashCode() {
        int hashCode = Objects.hash(this.clauses);
        if (hashCode == 0) {
            hashCode = 1;
        }
        return hashCode;
    }

    @Override
    public Iterator<BooleanClause> iterator() {
        return this.clauses.iterator();
    }

    public List<BooleanClause> getClauses() {
        return this.clauses;
    }
}

