/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search;

import org.neo4j.shaded.lucene9.search.ScoreDoc;
import org.neo4j.shaded.lucene9.util.PriorityQueue;

public final class HitQueue
extends PriorityQueue<ScoreDoc> {
    public HitQueue(int size, boolean prePopulate) {
        super(size, () -> {
            if (prePopulate) {
                return new ScoreDoc(Integer.MAX_VALUE, Float.NEGATIVE_INFINITY);
            }
            return null;
        });
    }

    @Override
    protected final boolean lessThan(ScoreDoc hitA, ScoreDoc hitB) {
        if (hitA.score == hitB.score) {
            return hitA.doc > hitB.doc;
        }
        return hitA.score < hitB.score;
    }
}

