/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.neo4j.shaded.lucene9.index.FloatVectorValues;
import org.neo4j.shaded.lucene9.index.LeafReaderContext;
import org.neo4j.shaded.lucene9.search.VectorScorer;
import org.neo4j.shaded.lucene9.search.VectorSimilarityValuesSource;

class FloatVectorSimilarityValuesSource
extends VectorSimilarityValuesSource {
    private final float[] queryVector;

    public FloatVectorSimilarityValuesSource(float[] vector, String fieldName) {
        super(fieldName);
        this.queryVector = vector;
    }

    @Override
    public VectorScorer getScorer(LeafReaderContext ctx) throws IOException {
        FloatVectorValues vectorValues = ctx.reader().getFloatVectorValues(this.fieldName);
        if (vectorValues == null) {
            FloatVectorValues.checkField(ctx.reader(), this.fieldName);
            return null;
        }
        return vectorValues.scorer(this.queryVector);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fieldName, Arrays.hashCode(this.queryVector));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FloatVectorSimilarityValuesSource other = (FloatVectorSimilarityValuesSource)obj;
        return Objects.equals(this.fieldName, other.fieldName) && Arrays.equals(this.queryVector, other.queryVector);
    }

    @Override
    public String toString() {
        return "FloatVectorSimilarityValuesSource(fieldName=" + this.fieldName + " queryVector=" + Arrays.toString(this.queryVector) + ")";
    }
}

