/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.neo4j.shaded.lucene9.search.ConjunctionDISI;
import org.neo4j.shaded.lucene9.search.DocIdSetIterator;
import org.neo4j.shaded.lucene9.search.Scorer;
import org.neo4j.shaded.lucene9.search.TwoPhaseIterator;

public final class ConjunctionUtils {
    public static DocIdSetIterator intersectScorers(Collection<Scorer> scorers) {
        if (scorers.size() < 2) {
            throw new IllegalArgumentException("Cannot make a ConjunctionDISI of less than 2 iterators");
        }
        ArrayList<DocIdSetIterator> allIterators = new ArrayList<DocIdSetIterator>();
        ArrayList<TwoPhaseIterator> twoPhaseIterators = new ArrayList<TwoPhaseIterator>();
        for (Scorer scorer : scorers) {
            ConjunctionDISI.addScorer(scorer, allIterators, twoPhaseIterators);
        }
        return ConjunctionDISI.createConjunction(allIterators, twoPhaseIterators);
    }

    public static DocIdSetIterator intersectIterators(List<? extends DocIdSetIterator> iterators) {
        if (iterators.size() < 2) {
            throw new IllegalArgumentException("Cannot make a ConjunctionDISI of less than 2 iterators");
        }
        ArrayList<DocIdSetIterator> allIterators = new ArrayList<DocIdSetIterator>();
        ArrayList<TwoPhaseIterator> twoPhaseIterators = new ArrayList<TwoPhaseIterator>();
        for (DocIdSetIterator docIdSetIterator : iterators) {
            ConjunctionUtils.addIterator(docIdSetIterator, allIterators, twoPhaseIterators);
        }
        return ConjunctionDISI.createConjunction(allIterators, twoPhaseIterators);
    }

    public static DocIdSetIterator createConjunction(List<DocIdSetIterator> allIterators, List<TwoPhaseIterator> twoPhaseIterators) {
        return ConjunctionDISI.createConjunction(allIterators, twoPhaseIterators);
    }

    public static void addTwoPhaseIterator(TwoPhaseIterator twoPhaseIter, List<DocIdSetIterator> allIterators, List<TwoPhaseIterator> twoPhaseIterators) {
        ConjunctionDISI.addTwoPhaseIterator(twoPhaseIter, allIterators, twoPhaseIterators);
    }

    public static void addIterator(DocIdSetIterator disi, List<DocIdSetIterator> allIterators, List<TwoPhaseIterator> twoPhaseIterators) {
        ConjunctionDISI.addIterator(disi, allIterators, twoPhaseIterators);
    }
}

