/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.queryparser.xml.builders;

import org.neo4j.shaded.lucene9.queryparser.xml.DOMUtils;
import org.neo4j.shaded.lucene9.queryparser.xml.ParserException;
import org.neo4j.shaded.lucene9.queryparser.xml.QueryBuilder;
import org.neo4j.shaded.lucene9.queryparser.xml.QueryBuilderFactory;
import org.neo4j.shaded.lucene9.search.BoostQuery;
import org.neo4j.shaded.lucene9.search.ConstantScoreQuery;
import org.neo4j.shaded.lucene9.search.Query;
import org.w3c.dom.Element;

public class ConstantScoreQueryBuilder
implements QueryBuilder {
    private final QueryBuilderFactory queryFactory;

    public ConstantScoreQueryBuilder(QueryBuilderFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    @Override
    public Query getQuery(Element e) throws ParserException {
        Element queryElem = DOMUtils.getFirstChildOrFail(e);
        Query q = new ConstantScoreQuery(this.queryFactory.getQuery(queryElem));
        float boost = DOMUtils.getAttribute(e, "boost", 1.0f);
        if (boost != 1.0f) {
            q = new BoostQuery(q, boost);
        }
        return q;
    }
}

