/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.queryparser.flexible.standard.processors;

import java.util.List;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.QueryNodeException;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.messages.QueryParserMessages;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.nodes.QueryNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.processors.QueryNodeProcessorImpl;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.util.UnescapedCharSequence;
import org.neo4j.shaded.lucene9.queryparser.flexible.messages.MessageImpl;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.config.StandardQueryConfigHandler;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.WildcardQueryNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.parser.EscapeQuerySyntaxImpl;

public class AllowLeadingWildcardProcessor
extends QueryNodeProcessorImpl {
    @Override
    public QueryNode process(QueryNode queryTree) throws QueryNodeException {
        Boolean allowsLeadingWildcard = this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.ALLOW_LEADING_WILDCARD);
        if (allowsLeadingWildcard != null && !allowsLeadingWildcard.booleanValue()) {
            return super.process(queryTree);
        }
        return queryTree;
    }

    @Override
    protected QueryNode postProcessNode(QueryNode node) throws QueryNodeException {
        WildcardQueryNode wildcardNode;
        if (node instanceof WildcardQueryNode && (wildcardNode = (WildcardQueryNode)node).getText().length() > 0) {
            if (UnescapedCharSequence.wasEscaped(wildcardNode.getText(), 0)) {
                return node;
            }
            switch (wildcardNode.getText().charAt(0)) {
                case '*': 
                case '?': {
                    throw new QueryNodeException(new MessageImpl(QueryParserMessages.LEADING_WILDCARD_NOT_ALLOWED, node.toQueryString(new EscapeQuerySyntaxImpl())));
                }
            }
        }
        return node;
    }

    @Override
    protected QueryNode preProcessNode(QueryNode node) throws QueryNodeException {
        return node;
    }

    @Override
    protected List<QueryNode> setChildrenOrder(List<QueryNode> children) throws QueryNodeException {
        return children;
    }
}

