/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.queryparser.flexible.standard.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.neo4j.shaded.lucene9.queryparser.charstream.CharStream;
import org.neo4j.shaded.lucene9.queryparser.charstream.FastCharStream;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.QueryNodeParseException;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.messages.QueryParserMessages;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.nodes.AndQueryNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.nodes.BooleanQueryNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.nodes.BoostQueryNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.nodes.FieldQueryNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.nodes.FuzzyQueryNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.nodes.GroupQueryNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.nodes.ModifierQueryNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.nodes.OrQueryNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.nodes.QueryNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.nodes.QueryNodeImpl;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.nodes.QuotedFieldQueryNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.nodes.SlopQueryNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.parser.SyntaxParser;
import org.neo4j.shaded.lucene9.queryparser.flexible.messages.MessageImpl;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.IntervalQueryNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.MinShouldMatchNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.RegexpQueryNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.TermRangeQueryNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.After;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.AnalyzedText;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.AtLeast;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.Before;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.ContainedBy;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.Containing;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.Extend;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.FuzzyTerm;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.IntervalFunction;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.MaxGaps;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.MaxWidth;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.NonOverlapping;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.NotContainedBy;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.NotContaining;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.NotWithin;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.Or;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.Ordered;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.Overlapping;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.Phrase;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.Unordered;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.UnorderedNoOverlaps;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.Wildcard;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.Within;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.parser.EscapeQuerySyntaxImpl;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.parser.ParseException;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.parser.StandardSyntaxParserConstants;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.parser.StandardSyntaxParserTokenManager;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.parser.Token;

public class StandardSyntaxParser
implements SyntaxParser,
StandardSyntaxParserConstants {
    public StandardSyntaxParserTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[34];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[28];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private static final LookaheadSuccess jj_ls;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;
    private boolean trace_enabled;

    public StandardSyntaxParser() {
        this(new FastCharStream(Reader.nullReader()));
    }

    @Override
    public QueryNode parse(CharSequence query, CharSequence field) throws QueryNodeParseException {
        this.ReInit(new FastCharStream(new StringReader(query.toString())));
        try {
            return this.TopLevelQuery(field);
        }
        catch (ParseException tme) {
            tme.setQuery(query);
            throw tme;
        }
        catch (Error tme) {
            MessageImpl message = new MessageImpl(QueryParserMessages.INVALID_SYNTAX_CANNOT_PARSE, query, tme.getMessage());
            QueryNodeParseException e = new QueryNodeParseException(tme);
            e.setQuery(query);
            e.setNonLocalizedMessage(message);
            throw e;
        }
    }

    public static float parseFloat(Token token) {
        return Float.parseFloat(token.image);
    }

    public static int parseInt(Token token) {
        return Integer.parseInt(token.image);
    }

    public final QueryNode TopLevelQuery(CharSequence field) throws ParseException {
        QueryNode q = this.Query(field);
        this.jj_consume_token(0);
        return q;
    }

    private final QueryNode Query(CharSequence field) throws ParseException {
        QueryNode first;
        ArrayList<QueryNode> clauses = new ArrayList<QueryNode>();
        block3: while (true) {
            QueryNode node = this.DisjQuery(field);
            clauses.add(node);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[0] = this.jj_gen;
        if (clauses.size() == 1 && (first = (QueryNode)clauses.get(0)) instanceof ModifierQueryNode && ((ModifierQueryNode)first).getModifier() == ModifierQueryNode.Modifier.MOD_NOT) {
            clauses.set(0, new BooleanQueryNode(Collections.singletonList(first)));
        }
        return clauses.size() == 1 ? (QueryNode)clauses.get(0) : new BooleanQueryNode(clauses);
    }

    private final QueryNode DisjQuery(CharSequence field) throws ParseException {
        ArrayList<QueryNode> clauses = new ArrayList<QueryNode>();
        QueryNode node = this.ConjQuery(field);
        clauses.add(node);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(9);
            node = this.ConjQuery(field);
            clauses.add(node);
        }
        return clauses.size() == 1 ? (QueryNode)clauses.get(0) : new OrQueryNode(clauses);
    }

    private final QueryNode ConjQuery(CharSequence field) throws ParseException {
        ArrayList<QueryNode> clauses = new ArrayList<QueryNode>();
        QueryNode node = this.ModClause(field);
        clauses.add(node);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(8);
            node = this.ModClause(field);
            clauses.add(node);
        }
        return clauses.size() == 1 ? (QueryNode)clauses.get(0) : new AndQueryNode(clauses);
    }

    private final QueryNode ModClause(CharSequence field) throws ParseException {
        ModifierQueryNode.Modifier modifier = ModifierQueryNode.Modifier.MOD_NONE;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 10: 
            case 12: 
            case 13: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 12: {
                        this.jj_consume_token(12);
                        modifier = ModifierQueryNode.Modifier.MOD_REQ;
                        break block0;
                    }
                    case 10: 
                    case 13: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 13: {
                                this.jj_consume_token(13);
                                break;
                            }
                            case 10: {
                                this.jj_consume_token(10);
                                break;
                            }
                            default: {
                                this.jj_la1[3] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        modifier = ModifierQueryNode.Modifier.MOD_NOT;
                        break block0;
                    }
                }
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        QueryNode q = this.Clause(field);
        if (modifier != ModifierQueryNode.Modifier.MOD_NONE) {
            q = new ModifierQueryNode(q, modifier);
        }
        return q;
    }

    private final QueryNode Clause(CharSequence field) throws ParseException {
        QueryNode q;
        if (this.jj_2_3(2)) {
            q = this.FieldRangeExpr(field);
        } else {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 11: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    if (this.jj_2_1(2)) {
                        field = this.FieldName();
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 15: {
                                this.jj_consume_token(15);
                                break;
                            }
                            case 16: {
                                this.jj_consume_token(16);
                                break;
                            }
                            default: {
                                this.jj_la1[6] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                    }
                    if (this.jj_2_2(2)) {
                        q = this.Term(field);
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 29: {
                            q = this.GroupingExpr(field);
                            break block0;
                        }
                        case 11: 
                        case 23: 
                        case 24: 
                        case 25: {
                            q = this.IntervalExpr(field);
                            break block0;
                        }
                    }
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return q;
    }

    private final CharSequence FieldName() throws ParseException {
        Token name = this.jj_consume_token(25);
        return EscapeQuerySyntaxImpl.discardEscapeChar(name.image);
    }

    private final QueryNode GroupingExpr(CharSequence field) throws ParseException {
        Token minShouldMatch = null;
        this.jj_consume_token(29);
        QueryNode q = this.Query(field);
        this.jj_consume_token(14);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 21: {
                q = this.Boost(q);
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 56: {
                this.jj_consume_token(56);
                minShouldMatch = this.jj_consume_token(24);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
        q = minShouldMatch != null ? new MinShouldMatchNode(StandardSyntaxParser.parseInt(minShouldMatch), new GroupQueryNode(q)) : new GroupQueryNode(q);
        return q;
    }

    private final IntervalQueryNode IntervalExpr(CharSequence field) throws ParseException {
        IntervalFunction source = this.IntervalFun();
        return new IntervalQueryNode(field == null ? null : field.toString(), source);
    }

    private final IntervalFunction IntervalFun() throws ParseException {
        if (this.jj_2_4(2)) {
            IntervalFunction source = this.IntervalAtLeast();
            return source;
        }
        if (this.jj_2_5(2)) {
            IntervalFunction source = this.IntervalMaxWidth();
            return source;
        }
        if (this.jj_2_6(2)) {
            IntervalFunction source = this.IntervalMaxGaps();
            return source;
        }
        if (this.jj_2_7(2)) {
            IntervalFunction source = this.IntervalOrdered();
            return source;
        }
        if (this.jj_2_8(2)) {
            IntervalFunction source = this.IntervalUnordered();
            return source;
        }
        if (this.jj_2_9(2)) {
            IntervalFunction source = this.IntervalUnorderedNoOverlaps();
            return source;
        }
        if (this.jj_2_10(2)) {
            IntervalFunction source = this.IntervalOr();
            return source;
        }
        if (this.jj_2_11(2)) {
            IntervalFunction source = this.IntervalWildcard();
            return source;
        }
        if (this.jj_2_12(2)) {
            IntervalFunction source = this.IntervalAfter();
            return source;
        }
        if (this.jj_2_13(2)) {
            IntervalFunction source = this.IntervalBefore();
            return source;
        }
        if (this.jj_2_14(2)) {
            IntervalFunction source = this.IntervalPhrase();
            return source;
        }
        if (this.jj_2_15(2)) {
            IntervalFunction source = this.IntervalContaining();
            return source;
        }
        if (this.jj_2_16(2)) {
            IntervalFunction source = this.IntervalNotContaining();
            return source;
        }
        if (this.jj_2_17(2)) {
            IntervalFunction source = this.IntervalContainedBy();
            return source;
        }
        if (this.jj_2_18(2)) {
            IntervalFunction source = this.IntervalNotContainedBy();
            return source;
        }
        if (this.jj_2_19(2)) {
            IntervalFunction source = this.IntervalWithin();
            return source;
        }
        if (this.jj_2_20(2)) {
            IntervalFunction source = this.IntervalNotWithin();
            return source;
        }
        if (this.jj_2_21(2)) {
            IntervalFunction source = this.IntervalOverlapping();
            return source;
        }
        if (this.jj_2_22(2)) {
            IntervalFunction source = this.IntervalNonOverlapping();
            return source;
        }
        if (this.jj_2_23(2)) {
            IntervalFunction source = this.IntervalExtend();
            return source;
        }
        if (this.jj_2_24(2)) {
            IntervalFunction source = this.IntervalFuzzyTerm();
            return source;
        }
        if (this.jj_2_25(2)) {
            IntervalFunction source = this.IntervalText();
            return source;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final IntervalFunction IntervalAtLeast() throws ParseException {
        ArrayList<IntervalFunction> sources = new ArrayList<IntervalFunction>();
        this.jj_consume_token(11);
        this.jj_consume_token(30);
        this.jj_consume_token(29);
        Token minShouldMatch = this.jj_consume_token(24);
        block3: while (true) {
            IntervalFunction source = this.IntervalFun();
            sources.add(source);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 11: 
                case 23: 
                case 24: 
                case 25: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[11] = this.jj_gen;
        this.jj_consume_token(14);
        return new AtLeast(StandardSyntaxParser.parseInt(minShouldMatch), sources);
    }

    private final IntervalFunction IntervalMaxWidth() throws ParseException {
        this.jj_consume_token(11);
        this.jj_consume_token(39);
        this.jj_consume_token(29);
        Token maxWidth = this.jj_consume_token(24);
        IntervalFunction source = this.IntervalFun();
        this.jj_consume_token(14);
        return new MaxWidth(StandardSyntaxParser.parseInt(maxWidth), source);
    }

    private final IntervalFunction IntervalMaxGaps() throws ParseException {
        this.jj_consume_token(11);
        this.jj_consume_token(38);
        this.jj_consume_token(29);
        Token maxGaps = this.jj_consume_token(24);
        IntervalFunction source = this.IntervalFun();
        this.jj_consume_token(14);
        return new MaxGaps(StandardSyntaxParser.parseInt(maxGaps), source);
    }

    private final IntervalFunction IntervalUnordered() throws ParseException {
        ArrayList<IntervalFunction> sources = new ArrayList<IntervalFunction>();
        this.jj_consume_token(11);
        this.jj_consume_token(47);
        this.jj_consume_token(29);
        block3: while (true) {
            IntervalFunction source = this.IntervalFun();
            sources.add(source);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 11: 
                case 23: 
                case 24: 
                case 25: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[12] = this.jj_gen;
        this.jj_consume_token(14);
        return new Unordered(sources);
    }

    private final IntervalFunction IntervalUnorderedNoOverlaps() throws ParseException {
        this.jj_consume_token(11);
        this.jj_consume_token(48);
        this.jj_consume_token(29);
        IntervalFunction a = this.IntervalFun();
        IntervalFunction b = this.IntervalFun();
        this.jj_consume_token(14);
        return new UnorderedNoOverlaps(a, b);
    }

    private final IntervalFunction IntervalOrdered() throws ParseException {
        ArrayList<IntervalFunction> sources = new ArrayList<IntervalFunction>();
        this.jj_consume_token(11);
        this.jj_consume_token(44);
        this.jj_consume_token(29);
        block3: while (true) {
            IntervalFunction source = this.IntervalFun();
            sources.add(source);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 11: 
                case 23: 
                case 24: 
                case 25: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[13] = this.jj_gen;
        this.jj_consume_token(14);
        return new Ordered(sources);
    }

    private final IntervalFunction IntervalOr() throws ParseException {
        ArrayList<IntervalFunction> sources = new ArrayList<IntervalFunction>();
        this.jj_consume_token(11);
        this.jj_consume_token(36);
        this.jj_consume_token(29);
        block3: while (true) {
            IntervalFunction source = this.IntervalFun();
            sources.add(source);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 11: 
                case 23: 
                case 24: 
                case 25: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[14] = this.jj_gen;
        this.jj_consume_token(14);
        return new Or(sources);
    }

    private final IntervalFunction IntervalPhrase() throws ParseException {
        ArrayList<IntervalFunction> sources = new ArrayList<IntervalFunction>();
        this.jj_consume_token(11);
        this.jj_consume_token(46);
        this.jj_consume_token(29);
        block3: while (true) {
            IntervalFunction source = this.IntervalFun();
            sources.add(source);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 11: 
                case 23: 
                case 24: 
                case 25: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[15] = this.jj_gen;
        this.jj_consume_token(14);
        return new Phrase(sources);
    }

    private final IntervalFunction IntervalBefore() throws ParseException {
        this.jj_consume_token(11);
        this.jj_consume_token(32);
        this.jj_consume_token(29);
        IntervalFunction source = this.IntervalFun();
        IntervalFunction reference = this.IntervalFun();
        this.jj_consume_token(14);
        return new Before(source, reference);
    }

    private final IntervalFunction IntervalAfter() throws ParseException {
        this.jj_consume_token(11);
        this.jj_consume_token(31);
        this.jj_consume_token(29);
        IntervalFunction source = this.IntervalFun();
        IntervalFunction reference = this.IntervalFun();
        this.jj_consume_token(14);
        return new After(source, reference);
    }

    private final IntervalFunction IntervalContaining() throws ParseException {
        this.jj_consume_token(11);
        this.jj_consume_token(34);
        this.jj_consume_token(29);
        IntervalFunction big = this.IntervalFun();
        IntervalFunction small = this.IntervalFun();
        this.jj_consume_token(14);
        return new Containing(big, small);
    }

    private final IntervalFunction IntervalNotContaining() throws ParseException {
        this.jj_consume_token(11);
        this.jj_consume_token(42);
        this.jj_consume_token(29);
        IntervalFunction minuend = this.IntervalFun();
        IntervalFunction subtrahend = this.IntervalFun();
        this.jj_consume_token(14);
        return new NotContaining(minuend, subtrahend);
    }

    private final IntervalFunction IntervalContainedBy() throws ParseException {
        this.jj_consume_token(11);
        this.jj_consume_token(33);
        this.jj_consume_token(29);
        IntervalFunction small = this.IntervalFun();
        IntervalFunction big = this.IntervalFun();
        this.jj_consume_token(14);
        return new ContainedBy(small, big);
    }

    private final IntervalFunction IntervalNotContainedBy() throws ParseException {
        this.jj_consume_token(11);
        this.jj_consume_token(41);
        this.jj_consume_token(29);
        IntervalFunction small = this.IntervalFun();
        IntervalFunction big = this.IntervalFun();
        this.jj_consume_token(14);
        return new NotContainedBy(small, big);
    }

    private final IntervalFunction IntervalWithin() throws ParseException {
        this.jj_consume_token(11);
        this.jj_consume_token(50);
        this.jj_consume_token(29);
        IntervalFunction source = this.IntervalFun();
        Token positions = this.jj_consume_token(24);
        IntervalFunction reference = this.IntervalFun();
        this.jj_consume_token(14);
        return new Within(source, StandardSyntaxParser.parseInt(positions), reference);
    }

    private final IntervalFunction IntervalExtend() throws ParseException {
        this.jj_consume_token(11);
        this.jj_consume_token(35);
        this.jj_consume_token(29);
        IntervalFunction source = this.IntervalFun();
        Token before = this.jj_consume_token(24);
        Token after = this.jj_consume_token(24);
        this.jj_consume_token(14);
        return new Extend(source, StandardSyntaxParser.parseInt(before), StandardSyntaxParser.parseInt(after));
    }

    private final IntervalFunction IntervalNotWithin() throws ParseException {
        this.jj_consume_token(11);
        this.jj_consume_token(43);
        this.jj_consume_token(29);
        IntervalFunction minuend = this.IntervalFun();
        Token positions = this.jj_consume_token(24);
        IntervalFunction subtrahend = this.IntervalFun();
        this.jj_consume_token(14);
        return new NotWithin(minuend, StandardSyntaxParser.parseInt(positions), subtrahend);
    }

    private final IntervalFunction IntervalOverlapping() throws ParseException {
        this.jj_consume_token(11);
        this.jj_consume_token(45);
        this.jj_consume_token(29);
        IntervalFunction source = this.IntervalFun();
        IntervalFunction reference = this.IntervalFun();
        this.jj_consume_token(14);
        return new Overlapping(source, reference);
    }

    private final IntervalFunction IntervalNonOverlapping() throws ParseException {
        this.jj_consume_token(11);
        this.jj_consume_token(40);
        this.jj_consume_token(29);
        IntervalFunction minuend = this.IntervalFun();
        IntervalFunction subtrahend = this.IntervalFun();
        this.jj_consume_token(14);
        return new NonOverlapping(minuend, subtrahend);
    }

    private final IntervalFunction IntervalWildcard() throws ParseException {
        String wildcard;
        Token maxExpansions = null;
        this.jj_consume_token(11);
        this.jj_consume_token(49);
        this.jj_consume_token(29);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 24: 
            case 25: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 25: {
                        this.jj_consume_token(25);
                        break;
                    }
                    case 24: {
                        this.jj_consume_token(24);
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                wildcard = this.token.image;
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                wildcard = this.token.image.substring(1, this.token.image.length() - 1);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 24: {
                maxExpansions = this.jj_consume_token(24);
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
            }
        }
        this.jj_consume_token(14);
        return new Wildcard(wildcard, maxExpansions == null ? 0 : StandardSyntaxParser.parseInt(maxExpansions));
    }

    private final IntervalFunction IntervalFuzzyTerm() throws ParseException {
        String term;
        Token maxEdits = null;
        Token maxExpansions = null;
        this.jj_consume_token(11);
        this.jj_consume_token(37);
        this.jj_consume_token(29);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 24: 
            case 25: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 25: {
                        this.jj_consume_token(25);
                        break;
                    }
                    case 24: {
                        this.jj_consume_token(24);
                        break;
                    }
                    default: {
                        this.jj_la1[19] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                term = this.token.image;
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                term = this.token.image.substring(1, this.token.image.length() - 1);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (this.jj_2_26(2)) {
            maxEdits = this.jj_consume_token(24);
        }
        if (this.jj_2_27(2)) {
            maxExpansions = this.jj_consume_token(24);
        }
        this.jj_consume_token(14);
        return new FuzzyTerm(term, maxEdits == null ? null : Integer.valueOf(StandardSyntaxParser.parseInt(maxEdits)), maxExpansions == null ? null : Integer.valueOf(StandardSyntaxParser.parseInt(maxExpansions)));
    }

    private final IntervalFunction IntervalText() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                return new AnalyzedText(this.token.image.substring(1, this.token.image.length() - 1));
            }
            case 24: 
            case 25: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 25: {
                        this.jj_consume_token(25);
                        break;
                    }
                    case 24: {
                        this.jj_consume_token(24);
                        break;
                    }
                    default: {
                        this.jj_la1[21] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return new AnalyzedText(this.token.image);
            }
        }
        this.jj_la1[22] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final QueryNode Boost(QueryNode node) throws ParseException {
        this.jj_consume_token(21);
        Token boost = this.jj_consume_token(24);
        return node == null ? node : new BoostQueryNode(node, StandardSyntaxParser.parseFloat(boost));
    }

    private final QueryNode FuzzyOp(CharSequence field, Token term, QueryNode node) throws ParseException {
        Token similarity = null;
        this.jj_consume_token(22);
        if (this.jj_2_28(2)) {
            similarity = this.jj_consume_token(24);
        }
        float fms = 2.0f;
        if (similarity != null) {
            fms = StandardSyntaxParser.parseFloat(similarity);
            if (fms < 0.0f) {
                throw new ParseException(new MessageImpl(QueryParserMessages.INVALID_SYNTAX_FUZZY_LIMITS));
            }
            if (fms >= 1.0f && fms != (float)((int)fms)) {
                throw new ParseException(new MessageImpl(QueryParserMessages.INVALID_SYNTAX_FUZZY_EDITS));
            }
        }
        return new FuzzyQueryNode(field, EscapeQuerySyntaxImpl.discardEscapeChar(term.image), fms, term.beginColumn, term.endColumn);
    }

    private final TermRangeQueryNode FieldRangeExpr(CharSequence field) throws ParseException {
        FieldQueryNode qUpper;
        FieldQueryNode qLower;
        boolean upperInclusive;
        boolean lowerInclusive;
        field = this.FieldName();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Token operator = this.token;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 25: {
                this.jj_consume_token(25);
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Token term = this.token;
        if (term.kind == 23) {
            term.image = term.image.substring(1, term.image.length() - 1);
        }
        switch (operator.kind) {
            case 17: {
                lowerInclusive = true;
                upperInclusive = false;
                qLower = new FieldQueryNode(field, "*", term.beginColumn, term.endColumn);
                qUpper = new FieldQueryNode(field, EscapeQuerySyntaxImpl.discardEscapeChar(term.image), term.beginColumn, term.endColumn);
                break;
            }
            case 18: {
                lowerInclusive = true;
                upperInclusive = true;
                qLower = new FieldQueryNode(field, "*", term.beginColumn, term.endColumn);
                qUpper = new FieldQueryNode(field, EscapeQuerySyntaxImpl.discardEscapeChar(term.image), term.beginColumn, term.endColumn);
                break;
            }
            case 19: {
                lowerInclusive = false;
                upperInclusive = true;
                qLower = new FieldQueryNode(field, EscapeQuerySyntaxImpl.discardEscapeChar(term.image), term.beginColumn, term.endColumn);
                qUpper = new FieldQueryNode(field, "*", term.beginColumn, term.endColumn);
                break;
            }
            case 20: {
                lowerInclusive = true;
                upperInclusive = true;
                qLower = new FieldQueryNode(field, EscapeQuerySyntaxImpl.discardEscapeChar(term.image), term.beginColumn, term.endColumn);
                qUpper = new FieldQueryNode(field, "*", term.beginColumn, term.endColumn);
                break;
            }
            default: {
                throw new Error("Unhandled case, operator=" + operator);
            }
        }
        return new TermRangeQueryNode(qLower, qUpper, lowerInclusive, upperInclusive);
    }

    private final QueryNode Term(CharSequence field) throws ParseException {
        QueryNode q;
        Object fuzzySlop = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 26: {
                Token term = this.jj_consume_token(26);
                String v = term.image.substring(1, term.image.length() - 1);
                q = new RegexpQueryNode(field, v, 0, v.length());
                break;
            }
            case 24: 
            case 25: {
                Token term;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 25: {
                        term = this.jj_consume_token(25);
                        break;
                    }
                    case 24: {
                        term = this.jj_consume_token(24);
                        break;
                    }
                    default: {
                        this.jj_la1[25] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                q = new FieldQueryNode(field, EscapeQuerySyntaxImpl.discardEscapeChar(term.image), term.beginColumn, term.endColumn);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 22: {
                        q = this.FuzzyOp(field, term, q);
                        break block0;
                    }
                }
                this.jj_la1[26] = this.jj_gen;
                break;
            }
            case 27: 
            case 28: {
                q = this.TermRangeExpr(field);
                break;
            }
            case 23: {
                q = this.QuotedTerm(field);
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 21: {
                q = this.Boost(q);
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
            }
        }
        return q;
    }

    private final QueryNode QuotedTerm(CharSequence field) throws ParseException {
        Token term = this.jj_consume_token(23);
        String image = term.image.substring(1, term.image.length() - 1);
        QueryNodeImpl q = new QuotedFieldQueryNode(field, EscapeQuerySyntaxImpl.discardEscapeChar(image), term.beginColumn + 1, term.endColumn - 1);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 22: {
                this.jj_consume_token(22);
                Token slop = this.jj_consume_token(24);
                q = new SlopQueryNode(q, StandardSyntaxParser.parseInt(slop));
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
            }
        }
        return q;
    }

    private final TermRangeQueryNode TermRangeExpr(CharSequence field) throws ParseException {
        boolean leftInclusive = false;
        boolean rightInclusive = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 27: {
                this.jj_consume_token(27);
                leftInclusive = true;
                break;
            }
            case 28: {
                this.jj_consume_token(28);
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 55: {
                this.jj_consume_token(55);
                break;
            }
            case 54: {
                this.jj_consume_token(54);
                break;
            }
            case 51: {
                this.jj_consume_token(51);
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Token left = this.token;
        this.jj_consume_token(51);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 55: {
                this.jj_consume_token(55);
                break;
            }
            case 54: {
                this.jj_consume_token(54);
                break;
            }
            case 51: {
                this.jj_consume_token(51);
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Token right = this.token;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 52: {
                this.jj_consume_token(52);
                rightInclusive = true;
                break;
            }
            case 53: {
                this.jj_consume_token(53);
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (left.kind == 54) {
            left.image = left.image.substring(1, left.image.length() - 1);
        }
        if (right.kind == 54) {
            right.image = right.image.substring(1, right.image.length() - 1);
        }
        FieldQueryNode qLower = new FieldQueryNode(field, EscapeQuerySyntaxImpl.discardEscapeChar(left.image), left.beginColumn, left.endColumn);
        FieldQueryNode qUpper = new FieldQueryNode(field, EscapeQuerySyntaxImpl.discardEscapeChar(right.image), right.beginColumn, right.endColumn);
        return new TermRangeQueryNode(qLower, qUpper, leftInclusive, rightInclusive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    private boolean jj_3R_IntervalUnorderedNoOverlaps_465_3_17() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(48);
    }

    private boolean jj_3R_IntervalContainedBy_557_3_25() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_FieldRangeExpr_744_3_11() {
        if (this.jj_3R_FieldName_344_3_9()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(17)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(18)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(19)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(20)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_IntervalWildcard_647_3_19() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(49);
    }

    private boolean jj_3R_QuotedTerm_834_5_47() {
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_IntervalUnordered_454_3_16() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(47);
    }

    private boolean jj_3R_IntervalNotContaining_546_3_24() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(42);
    }

    private boolean jj_3R_QuotedTerm_829_3_43() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_QuotedTerm_834_5_47()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_IntervalNonOverlapping_636_3_30() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(40);
    }

    private boolean jj_3R_IntervalMaxGaps_442_3_14() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(38);
    }

    private boolean jj_3_28() {
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_IntervalContaining_535_3_23() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(34);
    }

    private boolean jj_3R_FieldName_344_3_9() {
        return this.jj_scan_token(25);
    }

    private boolean jj_3R_IntervalOverlapping_626_3_29() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(45);
    }

    private boolean jj_3R_Term_806_10_41() {
        return this.jj_3R_FuzzyOp_717_3_45();
    }

    private boolean jj_3R_Term_808_8_37() {
        return this.jj_3R_QuotedTerm_829_3_43();
    }

    private boolean jj_3R_FuzzyOp_717_3_45() {
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_Term_810_5_38() {
        return this.jj_3R_Boost_700_3_44();
    }

    private boolean jj_3R_Term_807_8_36() {
        return this.jj_3R_TermRangeExpr_855_3_42();
    }

    private boolean jj_3_2() {
        return this.jj_3R_Term_798_3_10();
    }

    private boolean jj_3R_IntervalMaxWidth_430_3_13() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_Term_804_8_35() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(25)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(24)) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_Term_806_10_41()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_IntervalAfter_524_3_20() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(31);
    }

    private boolean jj_3_1() {
        if (this.jj_3R_FieldName_344_3_9()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(15)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(16)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_3() {
        return this.jj_3R_FieldRangeExpr_744_3_11();
    }

    private boolean jj_3R_Term_799_8_34() {
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_IntervalNotWithin_611_3_28() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(43);
    }

    private boolean jj_3R_IntervalBefore_513_3_21() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(32);
    }

    private boolean jj_3R_Term_798_3_10() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_Term_799_8_34()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_Term_804_8_35()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_Term_807_8_36()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_Term_808_8_37()) {
                        return true;
                    }
                }
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_Term_810_5_38()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_IntervalAtLeast_418_3_12() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(30);
    }

    private boolean jj_3R_Boost_700_3_44() {
        return this.jj_scan_token(21);
    }

    private boolean jj_3_25() {
        return this.jj_3R_IntervalText_685_5_33();
    }

    private boolean jj_3_24() {
        return this.jj_3R_IntervalFuzzyTerm_666_3_32();
    }

    private boolean jj_3_23() {
        return this.jj_3R_IntervalExtend_595_3_31();
    }

    private boolean jj_3_22() {
        return this.jj_3R_IntervalNonOverlapping_636_3_30();
    }

    private boolean jj_3_21() {
        return this.jj_3R_IntervalOverlapping_626_3_29();
    }

    private boolean jj_3R_IntervalPhrase_501_3_22() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(46);
    }

    private boolean jj_3_20() {
        return this.jj_3R_IntervalNotWithin_611_3_28();
    }

    private boolean jj_3R_IntervalExtend_595_3_31() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(35);
    }

    private boolean jj_3_19() {
        return this.jj_3R_IntervalWithin_579_3_27();
    }

    private boolean jj_3_18() {
        return this.jj_3R_IntervalNotContainedBy_568_3_26();
    }

    private boolean jj_3R_IntervalText_686_5_40() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(25)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(24)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_17() {
        return this.jj_3R_IntervalContainedBy_557_3_25();
    }

    private boolean jj_3R_IntervalText_685_5_39() {
        return this.jj_scan_token(23);
    }

    private boolean jj_3R_IntervalText_685_5_33() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_IntervalText_685_5_39()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_IntervalText_686_5_40()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_16() {
        return this.jj_3R_IntervalNotContaining_546_3_24();
    }

    private boolean jj_3_15() {
        return this.jj_3R_IntervalContaining_535_3_23();
    }

    private boolean jj_3_14() {
        return this.jj_3R_IntervalPhrase_501_3_22();
    }

    private boolean jj_3_13() {
        return this.jj_3R_IntervalBefore_513_3_21();
    }

    private boolean jj_3_12() {
        return this.jj_3R_IntervalAfter_524_3_20();
    }

    private boolean jj_3_11() {
        return this.jj_3R_IntervalWildcard_647_3_19();
    }

    private boolean jj_3_10() {
        return this.jj_3R_IntervalOr_489_3_18();
    }

    private boolean jj_3_9() {
        return this.jj_3R_IntervalUnorderedNoOverlaps_465_3_17();
    }

    private boolean jj_3R_IntervalOr_489_3_18() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(36);
    }

    private boolean jj_3_8() {
        return this.jj_3R_IntervalUnordered_454_3_16();
    }

    private boolean jj_3_7() {
        return this.jj_3R_IntervalOrdered_477_3_15();
    }

    private boolean jj_3_6() {
        return this.jj_3R_IntervalMaxGaps_442_3_14();
    }

    private boolean jj_3_5() {
        return this.jj_3R_IntervalMaxWidth_430_3_13();
    }

    private boolean jj_3_4() {
        return this.jj_3R_IntervalAtLeast_418_3_12();
    }

    private boolean jj_3_27() {
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_IntervalWithin_579_3_27() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(50);
    }

    private boolean jj_3_26() {
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_TermRangeExpr_856_6_46() {
        return this.jj_scan_token(27);
    }

    private boolean jj_3R_IntervalOrdered_477_3_15() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(44);
    }

    private boolean jj_3R_IntervalFuzzyTerm_666_3_32() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(37);
    }

    private boolean jj_3R_TermRangeExpr_855_3_42() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_TermRangeExpr_856_6_46()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(28)) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(55)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(54)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(51)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_IntervalNotContainedBy_568_3_26() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(41);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{1065368576, 512, 256, 9216, 13312, 13312, 98304, 595593216, 1065355264, 0x200000, 0, 0x3800800, 0x3800800, 0x3800800, 0x3800800, 0x3800800, 0x3000000, 0x3800000, 0x1000000, 0x3000000, 0x3800000, 0x3000000, 0x3800000, 0x1E0000, 0x3800000, 0x3000000, 0x400000, 528482304, 0x200000, 0x400000, 0x18000000, 0, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0xC80000, 0xC80000, 0x300000};
    }

    public StandardSyntaxParser(CharStream stream) {
        int i;
        this.token_source = new StandardSyntaxParserTokenManager(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 34; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(CharStream stream) {
        int i;
        this.token_source.ReInit(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 34; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public StandardSyntaxParser(StandardSyntaxParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 34; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(StandardSyntaxParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 34; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[57];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 34; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 57; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 28; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        StandardSyntaxParser.jj_la1_init_0();
        StandardSyntaxParser.jj_la1_init_1();
        jj_ls = new LookaheadSuccess();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

