/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn;

import java.util.Locale;
import java.util.Objects;
import org.neo4j.shaded.lucene9.analysis.Analyzer;
import org.neo4j.shaded.lucene9.queries.intervals.Intervals;
import org.neo4j.shaded.lucene9.queries.intervals.IntervalsSource;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.IntervalFunction;

public class MaxGaps
extends IntervalFunction {
    private final int maxGaps;
    private final IntervalFunction source;

    public MaxGaps(int maxGaps, IntervalFunction source) {
        this.maxGaps = maxGaps;
        this.source = Objects.requireNonNull(source);
    }

    @Override
    public IntervalsSource toIntervalSource(String field, Analyzer analyzer) {
        return Intervals.maxgaps((int)this.maxGaps, (IntervalsSource)this.source.toIntervalSource(field, analyzer));
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "fn:maxgaps(%s %s)", this.maxGaps, this.source);
    }
}

