/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.internal.hppc;

import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.shaded.lucene9.internal.hppc.BufferAllocationException;
import org.neo4j.shaded.lucene9.util.BitUtil;

class HashContainers {
    static final int DEFAULT_EXPECTED_ELEMENTS = 4;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final float MIN_LOAD_FACTOR = 0.01f;
    static final float MAX_LOAD_FACTOR = 0.99f;
    static final int MIN_HASH_ARRAY_LENGTH = 4;
    static final int MAX_HASH_ARRAY_LENGTH = 0x40000000;
    static final AtomicInteger ITERATION_SEED = new AtomicInteger();

    HashContainers() {
    }

    static int iterationIncrement(int seed) {
        return 29 + ((seed & 7) << 1);
    }

    static int nextBufferSize(int arraySize, int elements, double loadFactor) {
        assert (HashContainers.checkPowerOfTwo(arraySize));
        if (arraySize == 0x40000000) {
            throw new BufferAllocationException("Maximum array size exceeded for this load factor (elements: %d, load factor: %f)", elements, loadFactor);
        }
        return arraySize << 1;
    }

    static int expandAtCount(int arraySize, double loadFactor) {
        assert (HashContainers.checkPowerOfTwo(arraySize));
        return Math.min(arraySize - 1, (int)Math.ceil((double)arraySize * loadFactor));
    }

    static boolean checkPowerOfTwo(int arraySize) {
        assert (arraySize > 1);
        assert (BitUtil.nextHighestPowerOfTwo(arraySize) == arraySize);
        return true;
    }

    static int minBufferSize(int elements, double loadFactor) {
        if (elements < 0) {
            throw new IllegalArgumentException("Number of elements must be >= 0: " + elements);
        }
        long length = (long)Math.ceil((double)elements / loadFactor);
        if (length == (long)elements) {
            ++length;
        }
        if ((length = Math.max(4L, BitUtil.nextHighestPowerOfTwo(length))) > 0x40000000L) {
            throw new BufferAllocationException("Maximum array size exceeded for this load factor (elements: %d, load factor: %f)", elements, loadFactor);
        }
        return (int)length;
    }

    static void checkLoadFactor(double loadFactor, double minAllowedInclusive, double maxAllowedInclusive) {
        if (loadFactor < minAllowedInclusive || loadFactor > maxAllowedInclusive) {
            throw new BufferAllocationException("The load factor should be in range [%.2f, %.2f]: %f", minAllowedInclusive, maxAllowedInclusive, loadFactor);
        }
    }
}

