/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.neo4j.shaded.lucene9.index.FieldInfos;
import org.neo4j.shaded.lucene9.index.LeafReaderContext;
import org.neo4j.shaded.lucene9.index.PendingDeletes;
import org.neo4j.shaded.lucene9.index.PendingSoftDeletes;
import org.neo4j.shaded.lucene9.index.ReadersAndUpdates;
import org.neo4j.shaded.lucene9.index.SegmentCommitInfo;
import org.neo4j.shaded.lucene9.index.SegmentInfos;
import org.neo4j.shaded.lucene9.index.SegmentReader;
import org.neo4j.shaded.lucene9.index.StandardDirectoryReader;
import org.neo4j.shaded.lucene9.store.AlreadyClosedException;
import org.neo4j.shaded.lucene9.store.Directory;
import org.neo4j.shaded.lucene9.util.CollectionUtil;
import org.neo4j.shaded.lucene9.util.IOUtils;
import org.neo4j.shaded.lucene9.util.InfoStream;

final class ReaderPool
implements Closeable {
    private final Map<SegmentCommitInfo, ReadersAndUpdates> readerMap = new HashMap<SegmentCommitInfo, ReadersAndUpdates>();
    private final Directory directory;
    private final Directory originalDirectory;
    private final FieldInfos.FieldNumbers fieldNumbers;
    private final LongSupplier completedDelGenSupplier;
    private final InfoStream infoStream;
    private final SegmentInfos segmentInfos;
    private final String softDeletesField;
    private volatile boolean poolReaders;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    ReaderPool(Directory directory, Directory originalDirectory, SegmentInfos segmentInfos, FieldInfos.FieldNumbers fieldNumbers, LongSupplier completedDelGenSupplier, InfoStream infoStream, String softDeletesField, StandardDirectoryReader reader) throws IOException {
        this.directory = directory;
        this.originalDirectory = originalDirectory;
        this.segmentInfos = segmentInfos;
        this.fieldNumbers = fieldNumbers;
        this.completedDelGenSupplier = completedDelGenSupplier;
        this.infoStream = infoStream;
        this.softDeletesField = softDeletesField;
        if (reader != null) {
            List<LeafReaderContext> leaves = reader.leaves();
            assert (segmentInfos.size() == leaves.size());
            for (int i = 0; i < leaves.size(); ++i) {
                LeafReaderContext leaf = leaves.get(i);
                SegmentReader segReader = (SegmentReader)leaf.reader();
                SegmentReader newReader = new SegmentReader(segmentInfos.info(i), segReader, segReader.getLiveDocs(), segReader.getHardLiveDocs(), segReader.numDocs(), true);
                this.readerMap.put(newReader.getOriginalSegmentInfo(), new ReadersAndUpdates(segmentInfos.getIndexCreatedVersionMajor(), newReader, this.newPendingDeletes(newReader, newReader.getOriginalSegmentInfo())));
            }
        }
    }

    synchronized boolean assertInfoIsLive(SegmentCommitInfo info) {
        int idx = this.segmentInfos.indexOf(info);
        assert (idx != -1) : "info=" + info + " isn't live";
        assert (this.segmentInfos.info(idx) == info) : "info=" + info + " doesn't match live info in segmentInfos";
        return true;
    }

    synchronized boolean drop(SegmentCommitInfo info) throws IOException {
        ReadersAndUpdates rld = this.readerMap.get(info);
        if (rld != null) {
            assert (info == rld.info);
            this.readerMap.remove(info);
            rld.dropReaders();
            return true;
        }
        return false;
    }

    synchronized long ramBytesUsed() {
        long bytes = 0L;
        for (ReadersAndUpdates rld : this.readerMap.values()) {
            bytes += rld.ramBytesUsed.get();
        }
        return bytes;
    }

    synchronized boolean anyDeletions() {
        for (ReadersAndUpdates rld : this.readerMap.values()) {
            if (rld.getDelCount() <= 0) continue;
            return true;
        }
        return false;
    }

    void enableReaderPooling() {
        this.poolReaders = true;
    }

    boolean isReaderPoolingEnabled() {
        return this.poolReaders;
    }

    synchronized boolean release(ReadersAndUpdates rld, boolean assertInfoLive) throws IOException {
        boolean changed = false;
        rld.decRef();
        if (rld.refCount() == 0) {
            assert (!this.readerMap.containsKey(rld.info)) : "seg=" + rld.info + " has refCount 0 but still unexpectedly exists in the reader pool";
        } else {
            assert (rld.refCount() > 0) : "refCount=" + rld.refCount() + " reader=" + rld.info;
            if (!this.poolReaders && rld.refCount() == 1 && this.readerMap.containsKey(rld.info)) {
                if (rld.writeLiveDocs(this.directory)) {
                    assert (!assertInfoLive || this.assertInfoIsLive(rld.info));
                    changed = true;
                }
                if (rld.writeFieldUpdates(this.directory, this.fieldNumbers, this.completedDelGenSupplier.getAsLong(), this.infoStream)) {
                    changed = true;
                }
                if (rld.getNumDVUpdates() == 0L) {
                    rld.dropReaders();
                    this.readerMap.remove(rld.info);
                }
            }
        }
        return changed;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.dropAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean writeAllDocValuesUpdates() throws IOException {
        HashSet<ReadersAndUpdates> copy;
        ReaderPool readerPool = this;
        synchronized (readerPool) {
            copy = new HashSet<ReadersAndUpdates>(this.readerMap.values());
        }
        boolean any = false;
        for (ReadersAndUpdates rld : copy) {
            any |= rld.writeFieldUpdates(this.directory, this.fieldNumbers, this.completedDelGenSupplier.getAsLong(), this.infoStream);
        }
        return any;
    }

    boolean writeDocValuesUpdatesForMerge(List<SegmentCommitInfo> infos) throws IOException {
        boolean any = false;
        for (SegmentCommitInfo info : infos) {
            ReadersAndUpdates rld = this.get(info, false);
            if (rld == null) continue;
            any |= rld.writeFieldUpdates(this.directory, this.fieldNumbers, this.completedDelGenSupplier.getAsLong(), this.infoStream);
            rld.setIsMerging();
        }
        return any;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized List<ReadersAndUpdates> getReadersByRam() {
        class RamRecordingHolder {
            final ReadersAndUpdates updates;
            final long ramBytesUsed;

            RamRecordingHolder(ReadersAndUpdates updates) {
                this.updates = updates;
                this.ramBytesUsed = updates.ramBytesUsed.get();
            }
        }
        ArrayList<RamRecordingHolder> readersByRam;
        ReaderPool readerPool = this;
        synchronized (readerPool) {
            if (this.readerMap.isEmpty()) {
                return Collections.emptyList();
            }
            readersByRam = new ArrayList<RamRecordingHolder>(this.readerMap.size());
            for (ReadersAndUpdates rld : this.readerMap.values()) {
                readersByRam.add(new RamRecordingHolder(rld));
            }
        }
        CollectionUtil.introSort(readersByRam, (a, b) -> Long.compare(b.ramBytesUsed, a.ramBytesUsed));
        return Collections.unmodifiableList(readersByRam.stream().map(h -> h.updates).collect(Collectors.toList()));
    }

    synchronized void dropAll() throws IOException {
        Throwable priorE = null;
        Iterator<Map.Entry<SegmentCommitInfo, ReadersAndUpdates>> it = this.readerMap.entrySet().iterator();
        while (it.hasNext()) {
            ReadersAndUpdates rld = it.next().getValue();
            it.remove();
            try {
                rld.dropReaders();
            }
            catch (Throwable t) {
                priorE = IOUtils.useOrSuppress(priorE, t);
            }
        }
        assert (this.readerMap.size() == 0);
        if (priorE != null) {
            throw IOUtils.rethrowAlways(priorE);
        }
    }

    synchronized boolean commit(SegmentInfos infos) throws IOException {
        boolean atLeastOneChange = false;
        for (SegmentCommitInfo info : infos) {
            ReadersAndUpdates rld = this.readerMap.get(info);
            if (rld == null) continue;
            assert (rld.info == info);
            boolean changed = rld.writeLiveDocs(this.directory);
            if (!(changed |= rld.writeFieldUpdates(this.directory, this.fieldNumbers, this.completedDelGenSupplier.getAsLong(), this.infoStream))) continue;
            assert (this.assertInfoIsLive(info));
            atLeastOneChange = true;
        }
        return atLeastOneChange;
    }

    synchronized boolean anyDocValuesChanges() {
        for (ReadersAndUpdates rld : this.readerMap.values()) {
            if (rld.getNumDVUpdates() == 0L) continue;
            return true;
        }
        return false;
    }

    synchronized ReadersAndUpdates get(SegmentCommitInfo info, boolean create) {
        assert (info.info.dir == this.originalDirectory) : "info.dir=" + info.info.dir + " vs " + this.originalDirectory;
        if (this.closed.get()) {
            assert (this.readerMap.isEmpty()) : "Reader map is not empty: " + this.readerMap;
            throw new AlreadyClosedException("ReaderPool is already closed");
        }
        ReadersAndUpdates rld = this.readerMap.get(info);
        if (rld == null) {
            if (!create) {
                return null;
            }
            rld = new ReadersAndUpdates(this.segmentInfos.getIndexCreatedVersionMajor(), info, this.newPendingDeletes(info));
            this.readerMap.put(info, rld);
        } else assert (rld.info == info) : "rld.info=" + rld.info + " info=" + info + " isLive?=" + this.assertInfoIsLive(rld.info) + " vs " + this.assertInfoIsLive(info);
        if (create) {
            rld.incRef();
        }
        assert (this.noDups());
        return rld;
    }

    private PendingDeletes newPendingDeletes(SegmentCommitInfo info) {
        return this.softDeletesField == null ? new PendingDeletes(info) : new PendingSoftDeletes(this.softDeletesField, info);
    }

    private PendingDeletes newPendingDeletes(SegmentReader reader, SegmentCommitInfo info) {
        return this.softDeletesField == null ? new PendingDeletes(reader, info) : new PendingSoftDeletes(this.softDeletesField, reader, info);
    }

    private boolean noDups() {
        HashSet<String> seen = new HashSet<String>();
        for (SegmentCommitInfo info : this.readerMap.keySet()) {
            assert (!seen.contains(info.info.name)) : "seen twice: " + info.info.name;
            seen.add(info.info.name);
        }
        return true;
    }
}

