/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.index;

import java.io.IOException;
import org.neo4j.shaded.lucene9.index.FieldInfo;
import org.neo4j.shaded.lucene9.index.LeafReader;
import org.neo4j.shaded.lucene9.index.VectorEncoding;
import org.neo4j.shaded.lucene9.search.DocIdSetIterator;
import org.neo4j.shaded.lucene9.search.VectorScorer;

public abstract class FloatVectorValues
extends DocIdSetIterator {
    protected FloatVectorValues() {
    }

    public abstract int dimension();

    public abstract int size();

    @Override
    public final long cost() {
        return this.size();
    }

    public abstract float[] vectorValue() throws IOException;

    public static void checkField(LeafReader in, String field) {
        FieldInfo fi = in.getFieldInfos().fieldInfo(field);
        if (fi != null && fi.hasVectorValues() && fi.getVectorEncoding() != VectorEncoding.FLOAT32) {
            throw new IllegalStateException("Unexpected vector encoding (" + fi.getVectorEncoding() + ") for field " + field + "(expected=" + VectorEncoding.FLOAT32 + ")");
        }
    }

    public abstract VectorScorer scorer(float[] var1) throws IOException;
}

