/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.index;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.neo4j.shaded.lucene9.index.DocumentsWriterPerThread;
import org.neo4j.shaded.lucene9.index.LockableConcurrentApproximatePriorityQueue;
import org.neo4j.shaded.lucene9.store.AlreadyClosedException;
import org.neo4j.shaded.lucene9.util.ThreadInterruptedException;

final class DocumentsWriterPerThreadPool
implements Iterable<DocumentsWriterPerThread>,
Closeable {
    private final Set<DocumentsWriterPerThread> dwpts = Collections.newSetFromMap(new IdentityHashMap());
    private final LockableConcurrentApproximatePriorityQueue<DocumentsWriterPerThread> freeList = new LockableConcurrentApproximatePriorityQueue();
    private final Supplier<DocumentsWriterPerThread> dwptFactory;
    private int takenWriterPermits = 0;
    private volatile boolean closed;

    DocumentsWriterPerThreadPool(Supplier<DocumentsWriterPerThread> dwptFactory) {
        this.dwptFactory = dwptFactory;
    }

    synchronized int size() {
        return this.dwpts.size();
    }

    synchronized void lockNewWriters() {
        assert (this.takenWriterPermits >= 0);
        ++this.takenWriterPermits;
    }

    synchronized void unlockNewWriters() {
        assert (this.takenWriterPermits > 0);
        --this.takenWriterPermits;
        if (this.takenWriterPermits == 0) {
            this.notifyAll();
        }
    }

    private synchronized DocumentsWriterPerThread newWriter() {
        assert (this.takenWriterPermits >= 0);
        while (this.takenWriterPermits > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                throw new ThreadInterruptedException(ie);
            }
        }
        this.ensureOpen();
        DocumentsWriterPerThread dwpt = this.dwptFactory.get();
        dwpt.lock();
        this.dwpts.add(dwpt);
        return dwpt;
    }

    DocumentsWriterPerThread getAndLock() {
        this.ensureOpen();
        DocumentsWriterPerThread dwpt = this.freeList.lockAndPoll();
        if (dwpt != null) {
            return dwpt;
        }
        return this.newWriter();
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new AlreadyClosedException("DWPTPool is already closed");
        }
    }

    private synchronized boolean contains(DocumentsWriterPerThread state) {
        return this.dwpts.contains(state);
    }

    void marksAsFreeAndUnlock(DocumentsWriterPerThread state) {
        long ramBytesUsed = state.ramBytesUsed();
        assert (!(state.isFlushPending() || state.isAborted() || state.isQueueAdvanced())) : "DWPT has pending flush: " + state.isFlushPending() + " aborted=" + state.isAborted() + " queueAdvanced=" + state.isQueueAdvanced();
        assert (this.contains(state)) : "we tried to add a DWPT back to the pool but the pool doesn't know about this DWPT";
        this.freeList.addAndUnlock(state, ramBytesUsed);
    }

    @Override
    public synchronized Iterator<DocumentsWriterPerThread> iterator() {
        return List.copyOf(this.dwpts).iterator();
    }

    List<DocumentsWriterPerThread> filterAndLock(Predicate<DocumentsWriterPerThread> predicate) {
        ArrayList<DocumentsWriterPerThread> list = new ArrayList<DocumentsWriterPerThread>();
        for (DocumentsWriterPerThread perThread : this) {
            if (!predicate.test(perThread)) continue;
            perThread.lock();
            if (this.isRegistered(perThread)) {
                list.add(perThread);
                continue;
            }
            perThread.unlock();
        }
        return Collections.unmodifiableList(list);
    }

    synchronized boolean checkout(DocumentsWriterPerThread perThread) {
        assert (perThread.isHeldByCurrentThread());
        if (!this.dwpts.remove(perThread)) {
            assert (!this.freeList.contains(perThread));
            return false;
        }
        this.freeList.remove(perThread);
        return true;
    }

    synchronized boolean isRegistered(DocumentsWriterPerThread perThread) {
        return this.dwpts.contains(perThread);
    }

    @Override
    public synchronized void close() {
        this.closed = true;
    }
}

