/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.index;

import org.neo4j.shaded.lucene9.index.BinaryDocValues;
import org.neo4j.shaded.lucene9.index.DocValuesIterator;
import org.neo4j.shaded.lucene9.index.DocValuesType;
import org.neo4j.shaded.lucene9.index.NumericDocValues;
import org.neo4j.shaded.lucene9.util.Accountable;
import org.neo4j.shaded.lucene9.util.BitSet;
import org.neo4j.shaded.lucene9.util.BitSetIterator;
import org.neo4j.shaded.lucene9.util.BytesRef;
import org.neo4j.shaded.lucene9.util.IntroSorter;
import org.neo4j.shaded.lucene9.util.PriorityQueue;
import org.neo4j.shaded.lucene9.util.RamUsageEstimator;
import org.neo4j.shaded.lucene9.util.SparseFixedBitSet;
import org.neo4j.shaded.lucene9.util.packed.PackedInts;
import org.neo4j.shaded.lucene9.util.packed.PagedMutable;

abstract class DocValuesFieldUpdates
implements Accountable {
    protected static final int PAGE_SIZE = 1024;
    private static final long HAS_VALUE_MASK = 1L;
    private static final long HAS_NO_VALUE_MASK = 0L;
    private static final int SHIFT = 1;
    final String field;
    final DocValuesType type;
    final long delGen;
    private final int bitsPerValue;
    private boolean finished;
    protected final int maxDoc;
    protected PagedMutable docs;
    protected int size;

    public static Iterator mergedIterator(Iterator[] subs) {
        if (subs.length == 1) {
            return subs[0];
        }
        final PriorityQueue<Iterator> queue = new PriorityQueue<Iterator>(subs.length){

            @Override
            protected boolean lessThan(Iterator a, Iterator b) {
                int cmp = Integer.compare(a.docID(), b.docID());
                if (cmp == 0) {
                    cmp = Long.compare(b.delGen(), a.delGen());
                    assert (cmp != 0);
                }
                return cmp < 0;
            }
        };
        for (Iterator sub : subs) {
            if (sub.nextDoc() == Integer.MAX_VALUE) continue;
            queue.add(sub);
        }
        if (queue.size() == 0) {
            return null;
        }
        return new Iterator(){
            private int doc = -1;

            @Override
            public int nextDoc() {
                while (true) {
                    if (queue.size() == 0) {
                        this.doc = Integer.MAX_VALUE;
                        break;
                    }
                    int newDoc = ((Iterator)queue.top()).docID();
                    if (newDoc != this.doc) {
                        assert (newDoc > this.doc) : "doc=" + this.doc + " newDoc=" + newDoc;
                        this.doc = newDoc;
                        break;
                    }
                    if (((Iterator)queue.top()).nextDoc() == Integer.MAX_VALUE) {
                        queue.pop();
                        continue;
                    }
                    queue.updateTop();
                }
                return this.doc;
            }

            @Override
            public int docID() {
                return this.doc;
            }

            @Override
            long longValue() {
                return ((Iterator)queue.top()).longValue();
            }

            @Override
            BytesRef binaryValue() {
                return ((Iterator)queue.top()).binaryValue();
            }

            @Override
            public long delGen() {
                throw new UnsupportedOperationException();
            }

            @Override
            boolean hasValue() {
                return ((Iterator)queue.top()).hasValue();
            }
        };
    }

    protected DocValuesFieldUpdates(int maxDoc, long delGen, String field, DocValuesType type) {
        this.maxDoc = maxDoc;
        this.delGen = delGen;
        this.field = field;
        if (type == null) {
            throw new NullPointerException("DocValuesType must not be null");
        }
        this.type = type;
        this.bitsPerValue = PackedInts.bitsRequired(maxDoc - 1) + 1;
        this.docs = new PagedMutable(1L, 1024, this.bitsPerValue, 0.25f);
    }

    final boolean getFinished() {
        return this.finished;
    }

    abstract void add(int var1, long var2);

    abstract void add(int var1, BytesRef var2);

    abstract void add(int var1, Iterator var2);

    abstract Iterator iterator();

    final synchronized void finish() {
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        this.finished = true;
        if ((long)this.size < this.docs.size()) {
            this.resize(this.size);
        }
        if (this.size > 0) {
            final PackedInts.Mutable ords = PackedInts.getMutable(this.size, PackedInts.bitsRequired(this.size - 1), 0.25f);
            for (int i = 0; i < this.size; ++i) {
                ords.set(i, i);
            }
            new IntroSorter(){
                long pivotDoc;
                int pivotOrd;

                @Override
                protected void swap(int i, int j) {
                    long tmpOrd = ords.get(i);
                    ords.set(i, ords.get(j));
                    ords.set(j, tmpOrd);
                    DocValuesFieldUpdates.this.swap(i, j);
                }

                @Override
                protected int compare(int i, int j) {
                    int cmp = Long.compare(DocValuesFieldUpdates.this.docs.get(i) >>> 1, DocValuesFieldUpdates.this.docs.get(j) >>> 1);
                    if (cmp == 0) {
                        cmp = (int)(ords.get(i) - ords.get(j));
                    }
                    return cmp;
                }

                @Override
                protected void setPivot(int i) {
                    this.pivotDoc = DocValuesFieldUpdates.this.docs.get(i) >>> 1;
                    this.pivotOrd = (int)ords.get(i);
                }

                @Override
                protected int comparePivot(int j) {
                    int cmp = Long.compare(this.pivotDoc, DocValuesFieldUpdates.this.docs.get(j) >>> 1);
                    if (cmp == 0) {
                        cmp = this.pivotOrd - (int)ords.get(j);
                    }
                    return cmp;
                }
            }.sort(0, this.size);
        }
    }

    synchronized boolean any() {
        return this.size > 0;
    }

    final synchronized int size() {
        return this.size;
    }

    synchronized void reset(int doc) {
        this.addInternal(doc, 0L);
    }

    final synchronized int add(int doc) {
        return this.addInternal(doc, 1L);
    }

    private synchronized int addInternal(int doc, long hasValueMask) {
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        assert (doc < this.maxDoc);
        if (this.size == Integer.MAX_VALUE) {
            throw new IllegalStateException("cannot support more than Integer.MAX_VALUE doc/value entries");
        }
        if (this.docs.size() == (long)this.size) {
            this.grow(this.size + 1);
        }
        this.docs.set(this.size, (long)doc << 1 | hasValueMask);
        ++this.size;
        return this.size - 1;
    }

    protected void swap(int i, int j) {
        long tmpDoc = this.docs.get(j);
        this.docs.set(j, this.docs.get(i));
        this.docs.set(i, tmpDoc);
    }

    protected void grow(int size) {
        this.docs = (PagedMutable)this.docs.grow(size);
    }

    protected void resize(int size) {
        this.docs = (PagedMutable)this.docs.resize(size);
    }

    protected final void ensureFinished() {
        if (!this.finished) {
            throw new IllegalStateException("call finish first");
        }
    }

    @Override
    public long ramBytesUsed() {
        return this.docs.ramBytesUsed() + (long)RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8L + 2L + 8L + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
    }

    static abstract class SingleValueDocValuesFieldUpdates
    extends DocValuesFieldUpdates {
        private final BitSet bitSet;
        private BitSet hasNoValue;
        private boolean hasAtLeastOneValue;

        protected SingleValueDocValuesFieldUpdates(int maxDoc, long delGen, String field, DocValuesType type) {
            super(maxDoc, delGen, field, type);
            this.bitSet = new SparseFixedBitSet(maxDoc);
        }

        @Override
        void add(int doc, long value) {
            assert (this.longValue() == value);
            this.bitSet.set(doc);
            this.hasAtLeastOneValue = true;
            if (this.hasNoValue != null) {
                this.hasNoValue.clear(doc);
            }
        }

        @Override
        void add(int doc, BytesRef value) {
            assert (this.binaryValue().equals(value));
            this.bitSet.set(doc);
            this.hasAtLeastOneValue = true;
            if (this.hasNoValue != null) {
                this.hasNoValue.clear(doc);
            }
        }

        @Override
        synchronized void reset(int doc) {
            this.bitSet.set(doc);
            this.hasAtLeastOneValue = true;
            if (this.hasNoValue == null) {
                this.hasNoValue = new SparseFixedBitSet(this.maxDoc);
            }
            this.hasNoValue.set(doc);
        }

        @Override
        void add(int docId, Iterator iterator) {
            throw new UnsupportedOperationException();
        }

        protected abstract BytesRef binaryValue();

        protected abstract long longValue();

        @Override
        synchronized boolean any() {
            return super.any() || this.hasAtLeastOneValue;
        }

        @Override
        public long ramBytesUsed() {
            return super.ramBytesUsed() + this.bitSet.ramBytesUsed() + (this.hasNoValue == null ? 0L : this.hasNoValue.ramBytesUsed());
        }

        @Override
        Iterator iterator() {
            final BitSetIterator iterator = new BitSetIterator(this.bitSet, this.maxDoc);
            return new Iterator(){

                @Override
                public int docID() {
                    return iterator.docID();
                }

                @Override
                public int nextDoc() {
                    return iterator.nextDoc();
                }

                @Override
                long longValue() {
                    return this.longValue();
                }

                @Override
                BytesRef binaryValue() {
                    return this.binaryValue();
                }

                @Override
                long delGen() {
                    return delGen;
                }

                @Override
                boolean hasValue() {
                    if (hasNoValue != null) {
                        return !hasNoValue.get(this.docID());
                    }
                    return true;
                }
            };
        }
    }

    protected static abstract class AbstractIterator
    extends Iterator {
        private final int size;
        private final PagedMutable docs;
        private long idx = 0L;
        private int doc = -1;
        private final long delGen;
        private boolean hasValue;

        AbstractIterator(int size, PagedMutable docs, long delGen) {
            this.size = size;
            this.docs = docs;
            this.delGen = delGen;
        }

        @Override
        public final int nextDoc() {
            long nextLongDoc;
            if (this.idx >= (long)this.size) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            long longDoc = this.docs.get(this.idx);
            ++this.idx;
            while (this.idx < (long)this.size && longDoc >>> 1 == (nextLongDoc = this.docs.get(this.idx)) >>> 1) {
                longDoc = nextLongDoc;
                ++this.idx;
            }
            boolean bl = this.hasValue = (longDoc & 1L) > 0L;
            if (this.hasValue) {
                this.set(this.idx - 1L);
            }
            this.doc = (int)(longDoc >> 1);
            return this.doc;
        }

        protected abstract void set(long var1);

        @Override
        public final int docID() {
            return this.doc;
        }

        @Override
        final long delGen() {
            return this.delGen;
        }

        @Override
        final boolean hasValue() {
            return this.hasValue;
        }
    }

    static abstract class Iterator
    extends DocValuesIterator {
        Iterator() {
        }

        @Override
        public final boolean advanceExact(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final long cost() {
            throw new UnsupportedOperationException();
        }

        @Override
        public abstract int nextDoc();

        abstract long longValue();

        abstract BytesRef binaryValue();

        abstract long delGen();

        abstract boolean hasValue();

        static BinaryDocValues asBinaryDocValues(final Iterator iterator) {
            return new BinaryDocValues(){

                @Override
                public int docID() {
                    return iterator.docID();
                }

                @Override
                public BytesRef binaryValue() {
                    return iterator.binaryValue();
                }

                @Override
                public boolean advanceExact(int target) {
                    return iterator.advanceExact(target);
                }

                @Override
                public int nextDoc() {
                    return iterator.nextDoc();
                }

                @Override
                public int advance(int target) {
                    return iterator.advance(target);
                }

                @Override
                public long cost() {
                    return iterator.cost();
                }
            };
        }

        static NumericDocValues asNumericDocValues(final Iterator iterator) {
            return new NumericDocValues(){

                @Override
                public long longValue() {
                    return iterator.longValue();
                }

                @Override
                public boolean advanceExact(int target) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int docID() {
                    return iterator.docID();
                }

                @Override
                public int nextDoc() {
                    return iterator.nextDoc();
                }

                @Override
                public int advance(int target) {
                    return iterator.advance(target);
                }

                @Override
                public long cost() {
                    return iterator.cost();
                }
            };
        }
    }
}

