/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.index;

import org.neo4j.shaded.lucene9.util.BitUtil;
import org.neo4j.shaded.lucene9.util.ByteBlockPool;

final class ByteSlicePool {
    public final ByteBlockPool pool;
    public static final int[] LEVEL_SIZE_ARRAY = new int[]{5, 14, 20, 30, 40, 40, 80, 80, 120, 200};
    public static final int[] NEXT_LEVEL_ARRAY = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 9};
    public static final int FIRST_LEVEL_SIZE = LEVEL_SIZE_ARRAY[0];

    public ByteSlicePool(ByteBlockPool pool) {
        this.pool = pool;
    }

    public int newSlice(int size) {
        if (size > 32768) {
            throw new IllegalArgumentException("Slice size " + size + " should be less than the block size 32768");
        }
        if (this.pool.byteUpto > 32768 - size) {
            this.pool.nextBuffer();
        }
        int upto = this.pool.byteUpto;
        this.pool.byteUpto += size;
        this.pool.buffer[this.pool.byteUpto - 1] = 16;
        return upto;
    }

    public int allocSlice(byte[] slice, int upto) {
        return this.allocKnownSizeSlice(slice, upto) >> 8;
    }

    public int allocKnownSizeSlice(byte[] slice, int upto) {
        int level = slice[upto] & 0xF;
        int newLevel = NEXT_LEVEL_ARRAY[level];
        int newSize = LEVEL_SIZE_ARRAY[newLevel];
        if (this.pool.byteUpto > 32768 - newSize) {
            this.pool.nextBuffer();
        }
        int newUpto = this.pool.byteUpto;
        int offset = newUpto + this.pool.byteOffset;
        this.pool.byteUpto += newSize;
        int past3Bytes = BitUtil.VH_LE_INT.get(slice, upto - 3) & 0xFFFFFF;
        assert (this.pool.buffer[newUpto + 3] == 0);
        BitUtil.VH_LE_INT.set(this.pool.buffer, newUpto, past3Bytes);
        BitUtil.VH_LE_INT.set(slice, upto - 3, offset);
        this.pool.buffer[this.pool.byteUpto - 1] = (byte)(0x10 | newLevel);
        return newUpto + 3 << 8 | newSize - 3;
    }
}

