/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.geo;

import java.text.ParseException;
import java.util.Arrays;
import org.neo4j.shaded.lucene9.geo.Component2D;
import org.neo4j.shaded.lucene9.geo.GeoUtils;
import org.neo4j.shaded.lucene9.geo.LatLonGeometry;
import org.neo4j.shaded.lucene9.geo.Polygon2D;
import org.neo4j.shaded.lucene9.geo.SimpleGeoJSONPolygonParser;

public final class Polygon
extends LatLonGeometry {
    private final double[] polyLats;
    private final double[] polyLons;
    private final Polygon[] holes;
    public final double minLat;
    public final double maxLat;
    public final double minLon;
    public final double maxLon;
    private final GeoUtils.WindingOrder windingOrder;

    public Polygon(double[] polyLats, double[] polyLons, Polygon ... holes) {
        int i;
        if (polyLats == null) {
            throw new IllegalArgumentException("polyLats must not be null");
        }
        if (polyLons == null) {
            throw new IllegalArgumentException("polyLons must not be null");
        }
        if (holes == null) {
            throw new IllegalArgumentException("holes must not be null");
        }
        if (polyLats.length != polyLons.length) {
            throw new IllegalArgumentException("polyLats and polyLons must be equal length");
        }
        if (polyLats.length < 4) {
            throw new IllegalArgumentException("at least 4 polygon points required");
        }
        if (polyLats[0] != polyLats[polyLats.length - 1]) {
            throw new IllegalArgumentException("first and last points of the polygon must be the same (it must close itself): polyLats[0]=" + polyLats[0] + " polyLats[" + (polyLats.length - 1) + "]=" + polyLats[polyLats.length - 1]);
        }
        if (polyLons[0] != polyLons[polyLons.length - 1]) {
            throw new IllegalArgumentException("first and last points of the polygon must be the same (it must close itself): polyLons[0]=" + polyLons[0] + " polyLons[" + (polyLons.length - 1) + "]=" + polyLons[polyLons.length - 1]);
        }
        for (i = 0; i < polyLats.length; ++i) {
            GeoUtils.checkLatitude(polyLats[i]);
            GeoUtils.checkLongitude(polyLons[i]);
        }
        for (i = 0; i < holes.length; ++i) {
            Polygon inner = holes[i];
            if (inner.holes.length <= 0) continue;
            throw new IllegalArgumentException("holes may not contain holes: polygons may not nest.");
        }
        this.polyLats = (double[])polyLats.clone();
        this.polyLons = (double[])polyLons.clone();
        this.holes = (Polygon[])holes.clone();
        double minLat = polyLats[0];
        double maxLat = polyLats[0];
        double minLon = polyLons[0];
        double maxLon = polyLons[0];
        double windingSum = 0.0;
        int numPts = polyLats.length - 1;
        int i2 = 1;
        int j = 0;
        while (i2 < numPts) {
            minLat = Math.min(polyLats[i2], minLat);
            maxLat = Math.max(polyLats[i2], maxLat);
            minLon = Math.min(polyLons[i2], minLon);
            maxLon = Math.max(polyLons[i2], maxLon);
            windingSum += (polyLons[j] - polyLons[numPts]) * (polyLats[i2] - polyLats[numPts]) - (polyLats[j] - polyLats[numPts]) * (polyLons[i2] - polyLons[numPts]);
            j = i2++;
        }
        this.minLat = minLat;
        this.maxLat = maxLat;
        this.minLon = minLon;
        this.maxLon = maxLon;
        this.windingOrder = windingSum < 0.0 ? GeoUtils.WindingOrder.CCW : GeoUtils.WindingOrder.CW;
    }

    public int numPoints() {
        return this.polyLats.length;
    }

    public double[] getPolyLats() {
        return (double[])this.polyLats.clone();
    }

    public double getPolyLat(int vertex) {
        return this.polyLats[vertex];
    }

    public double[] getPolyLons() {
        return (double[])this.polyLons.clone();
    }

    public double getPolyLon(int vertex) {
        return this.polyLons[vertex];
    }

    public Polygon[] getHoles() {
        return (Polygon[])this.holes.clone();
    }

    Polygon getHole(int i) {
        return this.holes[i];
    }

    public GeoUtils.WindingOrder getWindingOrder() {
        return this.windingOrder;
    }

    public int numHoles() {
        return this.holes.length;
    }

    @Override
    protected Component2D toComponent2D() {
        return Polygon2D.create(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.holes);
        result = 31 * result + Arrays.hashCode(this.polyLats);
        result = 31 * result + Arrays.hashCode(this.polyLons);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Polygon other = (Polygon)obj;
        if (!Arrays.equals(this.holes, other.holes)) {
            return false;
        }
        if (!Arrays.equals(this.polyLats, other.polyLats)) {
            return false;
        }
        return Arrays.equals(this.polyLons, other.polyLons);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.polyLats.length; ++i) {
            sb.append("[").append(this.polyLats[i]).append(", ").append(this.polyLons[i]).append("] ");
        }
        if (this.holes.length > 0) {
            sb.append(", holes=");
            sb.append(Arrays.toString(this.holes));
        }
        return sb.toString();
    }

    public static String verticesToGeoJSON(double[] lats, double[] lons) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < lats.length; ++i) {
            sb.append("[").append(lons[i]).append(", ").append(lats[i]).append("]");
            if (i == lats.length - 1) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    public String toGeoJSON() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(Polygon.verticesToGeoJSON(this.polyLats, this.polyLons));
        for (Polygon hole : this.holes) {
            sb.append(",");
            sb.append(Polygon.verticesToGeoJSON(hole.polyLats, hole.polyLons));
        }
        sb.append("]");
        return sb.toString();
    }

    public static Polygon[] fromGeoJSON(String geojson) throws ParseException {
        return new SimpleGeoJSONPolygonParser(geojson).parse();
    }
}

