/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.geo;

import org.neo4j.shaded.lucene9.geo.Component2D;
import org.neo4j.shaded.lucene9.geo.GeoUtils;
import org.neo4j.shaded.lucene9.geo.LatLonGeometry;
import org.neo4j.shaded.lucene9.geo.Point2D;

public final class Point
extends LatLonGeometry {
    private final double lat;
    private final double lon;

    public Point(double lat, double lon) {
        GeoUtils.checkLatitude(lat);
        GeoUtils.checkLongitude(lon);
        this.lat = lat;
        this.lon = lon;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    @Override
    protected Component2D toComponent2D() {
        return Point2D.create(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Point)) {
            return false;
        }
        Point point = (Point)o;
        return Double.compare(point.lat, this.lat) == 0 && Double.compare(point.lon, this.lon) == 0;
    }

    public int hashCode() {
        int result = Double.hashCode(this.lat);
        result = 31 * result + Double.hashCode(this.lon);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Point(");
        sb.append(this.lon);
        sb.append(",");
        sb.append(this.lat);
        sb.append(')');
        return sb.toString();
    }
}

