/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.document;

import java.util.Collection;
import org.neo4j.shaded.lucene9.document.Field;
import org.neo4j.shaded.lucene9.document.FieldType;
import org.neo4j.shaded.lucene9.document.SortedSetDocValuesRangeQuery;
import org.neo4j.shaded.lucene9.index.DocValuesType;
import org.neo4j.shaded.lucene9.search.MultiTermQuery;
import org.neo4j.shaded.lucene9.search.Query;
import org.neo4j.shaded.lucene9.search.TermInSetQuery;
import org.neo4j.shaded.lucene9.util.BytesRef;

public class SortedDocValuesField
extends Field {
    public static final FieldType TYPE = new FieldType();

    public SortedDocValuesField(String name, BytesRef bytes) {
        super(name, TYPE);
        this.fieldsData = bytes;
    }

    public static Query newSlowRangeQuery(String field, BytesRef lowerValue, BytesRef upperValue, boolean lowerInclusive, boolean upperInclusive) {
        return new SortedSetDocValuesRangeQuery(field, lowerValue, upperValue, lowerInclusive, upperInclusive);
    }

    public static Query newSlowExactQuery(String field, BytesRef value) {
        return SortedDocValuesField.newSlowRangeQuery(field, value, value, true, true);
    }

    @Deprecated(forRemoval=true, since="9.10")
    public static Query newSlowSetQuery(String field, BytesRef ... values) {
        return new TermInSetQuery(MultiTermQuery.DOC_VALUES_REWRITE, field, values);
    }

    public static Query newSlowSetQuery(String field, Collection<BytesRef> values) {
        return new TermInSetQuery(MultiTermQuery.DOC_VALUES_REWRITE, field, values);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.SORTED);
        TYPE.freeze();
    }
}

