/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.document;

import java.io.IOException;
import org.neo4j.shaded.lucene9.geo.GeoEncodingUtils;
import org.neo4j.shaded.lucene9.geo.GeoUtils;
import org.neo4j.shaded.lucene9.index.DocValues;
import org.neo4j.shaded.lucene9.index.LeafReaderContext;
import org.neo4j.shaded.lucene9.index.SortedNumericDocValues;
import org.neo4j.shaded.lucene9.search.ConstantScoreScorer;
import org.neo4j.shaded.lucene9.search.ConstantScoreWeight;
import org.neo4j.shaded.lucene9.search.IndexSearcher;
import org.neo4j.shaded.lucene9.search.Query;
import org.neo4j.shaded.lucene9.search.QueryVisitor;
import org.neo4j.shaded.lucene9.search.ScoreMode;
import org.neo4j.shaded.lucene9.search.Scorer;
import org.neo4j.shaded.lucene9.search.TwoPhaseIterator;
import org.neo4j.shaded.lucene9.search.Weight;

final class LatLonDocValuesBoxQuery
extends Query {
    private final String field;
    private final int minLatitude;
    private final int maxLatitude;
    private final int minLongitude;
    private final int maxLongitude;
    private final boolean crossesDateline;

    LatLonDocValuesBoxQuery(String field, double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
        GeoUtils.checkLatitude(minLatitude);
        GeoUtils.checkLatitude(maxLatitude);
        GeoUtils.checkLongitude(minLongitude);
        GeoUtils.checkLongitude(maxLongitude);
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        this.field = field;
        this.crossesDateline = minLongitude > maxLongitude;
        this.minLatitude = GeoEncodingUtils.encodeLatitudeCeil(minLatitude);
        this.maxLatitude = GeoEncodingUtils.encodeLatitude(maxLatitude);
        this.minLongitude = GeoEncodingUtils.encodeLongitudeCeil(minLongitude);
        this.maxLongitude = GeoEncodingUtils.encodeLongitude(maxLongitude);
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field)) {
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("box(minLat=").append(GeoEncodingUtils.decodeLatitude(this.minLatitude));
        sb.append(", maxLat=").append(GeoEncodingUtils.decodeLatitude(this.maxLatitude));
        sb.append(", minLon=").append(GeoEncodingUtils.decodeLongitude(this.minLongitude));
        sb.append(", maxLon=").append(GeoEncodingUtils.decodeLongitude(this.maxLongitude));
        return sb.append(")").toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        LatLonDocValuesBoxQuery other = (LatLonDocValuesBoxQuery)obj;
        return this.field.equals(other.field) && this.crossesDateline == other.crossesDateline && this.minLatitude == other.minLatitude && this.maxLatitude == other.maxLatitude && this.minLongitude == other.minLongitude && this.maxLongitude == other.maxLongitude;
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.field.hashCode();
        h = 31 * h + Boolean.hashCode(this.crossesDateline);
        h = 31 * h + Integer.hashCode(this.minLatitude);
        h = 31 * h + Integer.hashCode(this.maxLatitude);
        h = 31 * h + Integer.hashCode(this.minLongitude);
        h = 31 * h + Integer.hashCode(this.maxLongitude);
        return h;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, final float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                final SortedNumericDocValues values = context.reader().getSortedNumericDocValues(LatLonDocValuesBoxQuery.this.field);
                if (values == null) {
                    return null;
                }
                TwoPhaseIterator iterator = new TwoPhaseIterator(values){

                    @Override
                    public boolean matches() throws IOException {
                        int count = values.docValueCount();
                        for (int i = 0; i < count; ++i) {
                            long value = values.nextValue();
                            int lat = (int)(value >>> 32);
                            if (lat < LatLonDocValuesBoxQuery.this.minLatitude || lat > LatLonDocValuesBoxQuery.this.maxLatitude) continue;
                            int lon = (int)(value & 0xFFFFFFFFFFFFFFFFL);
                            if (LatLonDocValuesBoxQuery.this.crossesDateline ? lon > LatLonDocValuesBoxQuery.this.maxLongitude && lon < LatLonDocValuesBoxQuery.this.minLongitude : lon < LatLonDocValuesBoxQuery.this.minLongitude || lon > LatLonDocValuesBoxQuery.this.maxLongitude) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public float matchCost() {
                        return 5.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, boost, scoreMode, iterator);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, LatLonDocValuesBoxQuery.this.field);
            }
        };
    }
}

