/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.backward_codecs.store;

import java.io.IOException;
import org.neo4j.shaded.lucene9.backward_codecs.store.EndiannessReverserIndexInput;
import org.neo4j.shaded.lucene9.store.BufferedChecksumIndexInput;
import org.neo4j.shaded.lucene9.store.ChecksumIndexInput;
import org.neo4j.shaded.lucene9.store.IndexInput;

final class EndiannessReverserChecksumIndexInput
extends ChecksumIndexInput {
    private final ChecksumIndexInput in;

    EndiannessReverserChecksumIndexInput(IndexInput in) {
        super("Endianness reverser Checksum Index Input wrapper");
        this.in = new BufferedChecksumIndexInput(in);
    }

    @Override
    public long getChecksum() throws IOException {
        return this.in.getChecksum();
    }

    @Override
    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        this.in.readBytes(b, offset, len);
    }

    @Override
    public short readShort() throws IOException {
        return Short.reverseBytes(this.in.readShort());
    }

    @Override
    public int readInt() throws IOException {
        return Integer.reverseBytes(this.in.readInt());
    }

    @Override
    public long readLong() throws IOException {
        return Long.reverseBytes(this.in.readLong());
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public long getFilePointer() {
        return this.in.getFilePointer();
    }

    @Override
    public long length() {
        return this.in.length();
    }

    @Override
    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        return new EndiannessReverserIndexInput(this.in.slice(sliceDescription, offset, length));
    }
}

