/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.backward_codecs.lucene60;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.shaded.lucene9.backward_codecs.store.EndiannessReverserUtil;
import org.neo4j.shaded.lucene9.codecs.CodecUtil;
import org.neo4j.shaded.lucene9.codecs.PointsReader;
import org.neo4j.shaded.lucene9.index.FieldInfo;
import org.neo4j.shaded.lucene9.index.IndexFileNames;
import org.neo4j.shaded.lucene9.index.PointValues;
import org.neo4j.shaded.lucene9.index.SegmentReadState;
import org.neo4j.shaded.lucene9.store.ChecksumIndexInput;
import org.neo4j.shaded.lucene9.store.IndexInput;
import org.neo4j.shaded.lucene9.util.IOUtils;
import org.neo4j.shaded.lucene9.util.bkd.BKDReader;

public class Lucene60PointsReader
extends PointsReader {
    final IndexInput dataIn;
    final SegmentReadState readState;
    final Map<Integer, PointValues> readers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene60PointsReader(SegmentReadState readState) throws IOException {
        long fp;
        int fieldNumber;
        HashMap<Integer, Long> fieldToFileOffset;
        block15: {
            this.readers = new HashMap<Integer, PointValues>();
            this.readState = readState;
            String indexFileName = IndexFileNames.segmentFileName(readState.segmentInfo.name, readState.segmentSuffix, "dii");
            fieldToFileOffset = new HashMap<Integer, Long>();
            try (ChecksumIndexInput indexIn = EndiannessReverserUtil.openChecksumInput(readState.directory, indexFileName, readState.context);){
                Throwable priorE = null;
                try {
                    CodecUtil.checkIndexHeader(indexIn, "Lucene60PointsFormatMeta", 0, 0, readState.segmentInfo.getId(), readState.segmentSuffix);
                    int count = indexIn.readVInt();
                    for (int i = 0; i < count; ++i) {
                        fieldNumber = indexIn.readVInt();
                        fp = indexIn.readVLong();
                        fieldToFileOffset.put(fieldNumber, fp);
                    }
                }
                catch (Throwable t) {
                    try {
                        priorE = t;
                        break block15;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter(indexIn, priorE);
                    }
                }
                CodecUtil.checkFooter(indexIn, priorE);
            }
        }
        String dataFileName = IndexFileNames.segmentFileName(readState.segmentInfo.name, readState.segmentSuffix, "dim");
        boolean success = false;
        this.dataIn = EndiannessReverserUtil.openInput(readState.directory, dataFileName, readState.context);
        try {
            CodecUtil.checkIndexHeader(this.dataIn, "Lucene60PointsFormatData", 0, 0, readState.segmentInfo.getId(), readState.segmentSuffix);
            CodecUtil.retrieveChecksum(this.dataIn);
            for (Map.Entry ent : fieldToFileOffset.entrySet()) {
                fieldNumber = (Integer)ent.getKey();
                fp = (Long)ent.getValue();
                this.dataIn.seek(fp);
                BKDReader reader = new BKDReader(this.dataIn, this.dataIn, this.dataIn);
                this.readers.put(fieldNumber, reader);
            }
            success = true;
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(this);
    }

    @Override
    public PointValues getValues(String fieldName) {
        FieldInfo fieldInfo = this.readState.fieldInfos.fieldInfo(fieldName);
        if (fieldInfo == null) {
            throw new IllegalArgumentException("field=\"" + fieldName + "\" is unrecognized");
        }
        if (fieldInfo.getPointDimensionCount() == 0) {
            throw new IllegalArgumentException("field=\"" + fieldName + "\" did not index point values");
        }
        return this.readers.get(fieldInfo.number);
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.dataIn);
    }

    @Override
    public void close() throws IOException {
        this.dataIn.close();
        this.readers.clear();
    }
}

