/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.tokenattributes;

import org.neo4j.shaded.lucene9.analysis.tokenattributes.PositionIncrementAttribute;
import org.neo4j.shaded.lucene9.util.AttributeImpl;
import org.neo4j.shaded.lucene9.util.AttributeReflector;

public class PositionIncrementAttributeImpl
extends AttributeImpl
implements PositionIncrementAttribute {
    private int positionIncrement = 1;

    @Override
    public void setPositionIncrement(int positionIncrement) {
        if (positionIncrement < 0) {
            throw new IllegalArgumentException("Position increment must be zero or greater; got " + positionIncrement);
        }
        this.positionIncrement = positionIncrement;
    }

    @Override
    public int getPositionIncrement() {
        return this.positionIncrement;
    }

    @Override
    public void clear() {
        this.positionIncrement = 1;
    }

    @Override
    public void end() {
        this.positionIncrement = 0;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof PositionIncrementAttributeImpl) {
            PositionIncrementAttributeImpl _other = (PositionIncrementAttributeImpl)other;
            return this.positionIncrement == _other.positionIncrement;
        }
        return false;
    }

    public int hashCode() {
        return this.positionIncrement;
    }

    @Override
    public void copyTo(AttributeImpl target) {
        PositionIncrementAttribute t = (PositionIncrementAttribute)((Object)target);
        t.setPositionIncrement(this.positionIncrement);
    }

    @Override
    public void reflectWith(AttributeReflector reflector) {
        reflector.reflect(PositionIncrementAttribute.class, "positionIncrement", this.positionIncrement);
    }
}

