/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.payloads;

import org.neo4j.shaded.lucene9.util.BitUtil;

public class PayloadHelper {
    public static byte[] encodeFloat(float payload) {
        return PayloadHelper.encodeFloat(payload, new byte[4], 0);
    }

    public static byte[] encodeFloat(float payload, byte[] data, int offset) {
        BitUtil.VH_BE_FLOAT.set(data, offset, payload);
        return data;
    }

    public static byte[] encodeInt(int payload) {
        return PayloadHelper.encodeInt(payload, new byte[4], 0);
    }

    public static byte[] encodeInt(int payload, byte[] data, int offset) {
        BitUtil.VH_BE_INT.set(data, offset, payload);
        return data;
    }

    public static float decodeFloat(byte[] bytes) {
        return PayloadHelper.decodeFloat(bytes, 0);
    }

    public static final float decodeFloat(byte[] bytes, int offset) {
        return BitUtil.VH_BE_FLOAT.get(bytes, offset);
    }

    public static final int decodeInt(byte[] bytes, int offset) {
        return BitUtil.VH_BE_INT.get(bytes, offset);
    }
}

