/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.pattern;

import java.util.Map;
import org.neo4j.shaded.lucene9.analysis.TokenizerFactory;
import org.neo4j.shaded.lucene9.analysis.pattern.SimplePatternTokenizer;
import org.neo4j.shaded.lucene9.util.AttributeFactory;
import org.neo4j.shaded.lucene9.util.automaton.Automaton;
import org.neo4j.shaded.lucene9.util.automaton.Operations;
import org.neo4j.shaded.lucene9.util.automaton.RegExp;

public class SimplePatternTokenizerFactory
extends TokenizerFactory {
    public static final String NAME = "simplePattern";
    public static final String PATTERN = "pattern";
    private final Automaton dfa;
    private final int determinizeWorkLimit;

    public SimplePatternTokenizerFactory(Map<String, String> args) {
        super(args);
        this.determinizeWorkLimit = this.getInt(args, "determinizeWorkLimit", 10000);
        this.dfa = Operations.determinize(new RegExp(this.require(args, PATTERN)).toAutomaton(), this.determinizeWorkLimit);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public SimplePatternTokenizerFactory() {
        throw SimplePatternTokenizerFactory.defaultCtorException();
    }

    @Override
    public SimplePatternTokenizer create(AttributeFactory factory) {
        return new SimplePatternTokenizer(factory, this.dfa);
    }
}

