/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.pattern;

import java.util.Map;
import org.neo4j.shaded.lucene9.analysis.TokenizerFactory;
import org.neo4j.shaded.lucene9.analysis.pattern.SimplePatternSplitTokenizer;
import org.neo4j.shaded.lucene9.util.AttributeFactory;
import org.neo4j.shaded.lucene9.util.automaton.Automaton;
import org.neo4j.shaded.lucene9.util.automaton.Operations;
import org.neo4j.shaded.lucene9.util.automaton.RegExp;

public class SimplePatternSplitTokenizerFactory
extends TokenizerFactory {
    public static final String NAME = "simplePatternSplit";
    public static final String PATTERN = "pattern";
    private final Automaton dfa;
    private final int determinizeWorkLimit;

    public SimplePatternSplitTokenizerFactory(Map<String, String> args) {
        super(args);
        this.determinizeWorkLimit = this.getInt(args, "determinizeWorkLimit", 10000);
        this.dfa = Operations.determinize(new RegExp(this.require(args, PATTERN)).toAutomaton(), this.determinizeWorkLimit);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public SimplePatternSplitTokenizerFactory() {
        throw SimplePatternSplitTokenizerFactory.defaultCtorException();
    }

    @Override
    public SimplePatternSplitTokenizer create(AttributeFactory factory) {
        return new SimplePatternSplitTokenizer(factory, this.dfa);
    }
}

