/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.miscellaneous;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.neo4j.shaded.lucene9.analysis.TokenFilterFactory;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.analysis.miscellaneous.StemmerOverrideFilter;
import org.neo4j.shaded.lucene9.util.ResourceLoader;
import org.neo4j.shaded.lucene9.util.ResourceLoaderAware;

public class StemmerOverrideFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "stemmerOverride";
    private StemmerOverrideFilter.StemmerOverrideMap dictionary;
    private final String dictionaryFiles;
    private final boolean ignoreCase;

    public StemmerOverrideFilterFactory(Map<String, String> args) {
        super(args);
        this.dictionaryFiles = this.get(args, "dictionary");
        this.ignoreCase = this.getBoolean(args, "ignoreCase", false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public StemmerOverrideFilterFactory() {
        throw StemmerOverrideFilterFactory.defaultCtorException();
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        List<String> files;
        if (this.dictionaryFiles != null && (files = this.splitFileNames(this.dictionaryFiles)).size() > 0) {
            StemmerOverrideFilter.Builder builder = new StemmerOverrideFilter.Builder(this.ignoreCase);
            for (String file : files) {
                List<String> list = this.getLines(loader, file.trim());
                for (String line : list) {
                    String[] mapping = line.split("\t", 2);
                    builder.add(mapping[0], mapping[1]);
                }
            }
            this.dictionary = builder.build();
        }
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public TokenStream create(TokenStream input) {
        return this.dictionary == null ? input : new StemmerOverrideFilter(input, this.dictionary);
    }
}

