/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.miscellaneous;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.neo4j.shaded.lucene9.analysis.util.StemmerUtil;

public final class ScandinavianNormalizer {
    private final Set<Foldings> foldings;
    public static final Set<Foldings> ALL_FOLDINGS = Collections.unmodifiableSet(EnumSet.allOf(Foldings.class));
    static final char AA = '\u00c5';
    static final char aa = '\u00e5';
    static final char AE = '\u00c6';
    static final char ae = '\u00e6';
    static final char AE_se = '\u00c4';
    static final char ae_se = '\u00e4';
    static final char OE = '\u00d8';
    static final char oe = '\u00f8';
    static final char OE_se = '\u00d6';
    static final char oe_se = '\u00f6';

    public ScandinavianNormalizer(Set<Foldings> foldings) {
        this.foldings = foldings;
    }

    public int processToken(char[] buffer, int length) {
        for (int i = 0; i < length; ++i) {
            if (buffer[i] == '\u00e4') {
                buffer[i] = 230;
                continue;
            }
            if (buffer[i] == '\u00c4') {
                buffer[i] = 198;
                continue;
            }
            if (buffer[i] == '\u00f6') {
                buffer[i] = 248;
                continue;
            }
            if (buffer[i] == '\u00d6') {
                buffer[i] = 216;
                continue;
            }
            if (length - 1 <= i) continue;
            if (buffer[i] == 'a' && (this.foldings.contains((Object)Foldings.AA) && (buffer[i + 1] == 'a' || buffer[i + 1] == 'A') || this.foldings.contains((Object)Foldings.AO) && (buffer[i + 1] == 'o' || buffer[i + 1] == 'O'))) {
                length = StemmerUtil.delete(buffer, i + 1, length);
                buffer[i] = 229;
                continue;
            }
            if (buffer[i] == 'A' && (this.foldings.contains((Object)Foldings.AA) && (buffer[i + 1] == 'a' || buffer[i + 1] == 'A') || this.foldings.contains((Object)Foldings.AO) && (buffer[i + 1] == 'o' || buffer[i + 1] == 'O'))) {
                length = StemmerUtil.delete(buffer, i + 1, length);
                buffer[i] = 197;
                continue;
            }
            if (buffer[i] == 'a' && this.foldings.contains((Object)Foldings.AE) && (buffer[i + 1] == 'e' || buffer[i + 1] == 'E')) {
                length = StemmerUtil.delete(buffer, i + 1, length);
                buffer[i] = 230;
                continue;
            }
            if (buffer[i] == 'A' && this.foldings.contains((Object)Foldings.AE) && (buffer[i + 1] == 'e' || buffer[i + 1] == 'E')) {
                length = StemmerUtil.delete(buffer, i + 1, length);
                buffer[i] = 198;
                continue;
            }
            if (buffer[i] == 'o' && (this.foldings.contains((Object)Foldings.OE) && (buffer[i + 1] == 'e' || buffer[i + 1] == 'E') || this.foldings.contains((Object)Foldings.OO) && (buffer[i + 1] == 'o' || buffer[i + 1] == 'O'))) {
                length = StemmerUtil.delete(buffer, i + 1, length);
                buffer[i] = 248;
                continue;
            }
            if (buffer[i] != 'O' || (!this.foldings.contains((Object)Foldings.OE) || buffer[i + 1] != 'e' && buffer[i + 1] != 'E') && (!this.foldings.contains((Object)Foldings.OO) || buffer[i + 1] != 'o' && buffer[i + 1] != 'O')) continue;
            length = StemmerUtil.delete(buffer, i + 1, length);
            buffer[i] = 216;
        }
        return length;
    }

    public static enum Foldings {
        AA,
        AO,
        AE,
        OE,
        OO;

    }
}

