/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.de;

import java.io.IOException;
import org.neo4j.shaded.lucene9.analysis.TokenFilter;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.analysis.de.GermanStemmer;
import org.neo4j.shaded.lucene9.analysis.tokenattributes.CharTermAttribute;
import org.neo4j.shaded.lucene9.analysis.tokenattributes.KeywordAttribute;

public final class GermanStemFilter
extends TokenFilter {
    private GermanStemmer stemmer = new GermanStemmer();
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);

    public GermanStemFilter(TokenStream in) {
        super(in);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            String s;
            String term = this.termAtt.toString();
            if (!this.keywordAttr.isKeyword() && (s = this.stemmer.stem(term)) != null && !s.equals(term)) {
                this.termAtt.setEmpty().append(s);
            }
            return true;
        }
        return false;
    }

    public void setStemmer(GermanStemmer stemmer) {
        if (stemmer != null) {
            this.stemmer = stemmer;
        }
    }
}

