/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.fs.AdversarialFileChannel;
import org.neo4j.adversaries.fs.AdversarialInputStream;
import org.neo4j.adversaries.fs.AdversarialOutputStream;
import org.neo4j.adversaries.watcher.AdversarialFileWatcher;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.io.fs.watcher.FileWatcher;

public class AdversarialFileSystemAbstraction
implements FileSystemAbstraction {
    private final FileSystemAbstraction delegate;
    private final Adversary adversary;

    public AdversarialFileSystemAbstraction(Adversary adversary) {
        this(adversary, (FileSystemAbstraction)new DefaultFileSystemAbstraction());
    }

    public AdversarialFileSystemAbstraction(Adversary adversary, FileSystemAbstraction delegate) {
        this.adversary = adversary;
        this.delegate = delegate;
    }

    public FileWatcher fileWatcher() throws IOException {
        this.adversary.injectFailure(UnsupportedOperationException.class, IOException.class);
        return new AdversarialFileWatcher(this.delegate.fileWatcher(), this.adversary);
    }

    public StoreChannel open(Path fileName, Set<OpenOption> options) throws IOException {
        this.adversary.injectFailure(NoSuchFileException.class, IOException.class, SecurityException.class);
        return AdversarialFileChannel.wrap((StoreFileChannel)this.delegate.open(fileName, options), this.adversary);
    }

    public void renameFile(Path from, Path to, CopyOption ... copyOptions) throws IOException {
        this.adversary.injectFailure(NoSuchFileException.class, SecurityException.class);
        this.delegate.renameFile(from, to, copyOptions);
    }

    public OutputStream openAsOutputStream(Path fileName, boolean append) throws IOException {
        this.adversary.injectFailure(NoSuchFileException.class, SecurityException.class);
        return new AdversarialOutputStream(this.delegate.openAsOutputStream(fileName, append), this.adversary);
    }

    public StoreChannel write(Path fileName) throws IOException {
        this.adversary.injectFailure(NoSuchFileException.class, IOException.class, SecurityException.class);
        return AdversarialFileChannel.wrap((StoreFileChannel)this.delegate.write(fileName), this.adversary);
    }

    public StoreChannel read(Path fileName) throws IOException {
        this.adversary.injectFailure(NoSuchFileException.class, IOException.class, SecurityException.class);
        return AdversarialFileChannel.wrap((StoreFileChannel)this.delegate.read(fileName), this.adversary);
    }

    public void mkdir(Path fileName) throws IOException {
        this.adversary.injectFailure(FileAlreadyExistsException.class, SecurityException.class);
        this.delegate.mkdir(fileName);
    }

    public Path[] listFiles(Path directory) throws IOException {
        this.adversary.injectFailure(NotDirectoryException.class, SecurityException.class);
        return this.delegate.listFiles(directory);
    }

    public Path[] listFiles(Path directory, DirectoryStream.Filter<Path> filter) throws IOException {
        this.adversary.injectFailure(NotDirectoryException.class, SecurityException.class);
        return this.delegate.listFiles(directory, filter);
    }

    public long getFileSize(Path fileName) throws IOException {
        this.adversary.injectFailure(IOException.class, SecurityException.class);
        return this.delegate.getFileSize(fileName);
    }

    public long getBlockSize(Path file) throws IOException {
        this.adversary.injectFailure(SecurityException.class);
        return this.delegate.getBlockSize(file);
    }

    public void copyFile(Path from, Path to, CopyOption ... copyOptions) throws IOException {
        this.adversary.injectFailure(SecurityException.class, NoSuchFileException.class, IOException.class);
        this.delegate.copyFile(from, to, copyOptions);
    }

    public void copyRecursively(Path fromDirectory, Path toDirectory) throws IOException {
        this.adversary.injectFailure(SecurityException.class, IOException.class, NullPointerException.class);
        this.delegate.copyRecursively(fromDirectory, toDirectory);
    }

    public void deleteFile(Path fileName) throws IOException {
        this.adversary.injectFailure(NoSuchFileException.class, DirectoryNotEmptyException.class, SecurityException.class);
        this.delegate.deleteFile(fileName);
    }

    public InputStream openAsInputStream(Path fileName) throws IOException {
        this.adversary.injectFailure(NoSuchFileException.class, SecurityException.class);
        return new AdversarialInputStream(this.delegate.openAsInputStream(fileName), this.adversary);
    }

    public void moveToDirectory(Path file, Path toDirectory) throws IOException {
        this.adversary.injectFailure(SecurityException.class, IllegalArgumentException.class, NoSuchFileException.class, NullPointerException.class, IOException.class);
        this.delegate.moveToDirectory(file, toDirectory);
    }

    public void copyToDirectory(Path file, Path toDirectory) throws IOException {
        this.adversary.injectFailure(SecurityException.class, IllegalArgumentException.class, NoSuchFileException.class, NullPointerException.class, IOException.class);
        this.delegate.copyToDirectory(file, toDirectory);
    }

    public boolean isDirectory(Path file) {
        this.adversary.injectFailure(SecurityException.class);
        return this.delegate.isDirectory(file);
    }

    public boolean fileExists(Path file) {
        this.adversary.injectFailure(SecurityException.class);
        return this.delegate.fileExists(file);
    }

    public void mkdirs(Path fileName) throws IOException {
        this.adversary.injectFailure(SecurityException.class, IOException.class);
        this.delegate.mkdirs(fileName);
    }

    public void deleteRecursively(Path directory) throws IOException {
        this.adversary.injectFailure(SecurityException.class, NullPointerException.class, IOException.class);
        this.delegate.deleteRecursively(directory);
    }

    public void truncate(Path path, long size) throws IOException {
        this.adversary.injectFailure(NoSuchFileException.class, IOException.class, IllegalArgumentException.class, SecurityException.class, NullPointerException.class);
        this.delegate.truncate(path, size);
    }

    public long lastModifiedTime(Path file) throws IOException {
        this.adversary.injectFailure(SecurityException.class, NullPointerException.class, IOException.class);
        return this.delegate.lastModifiedTime(file);
    }

    public void deleteFileOrThrow(Path file) throws IOException {
        this.adversary.injectFailure(NoSuchFileException.class, IOException.class, SecurityException.class);
        this.delegate.deleteFileOrThrow(file);
    }

    public int getFileDescriptor(StoreChannel channel) {
        return this.delegate.getFileDescriptor(channel);
    }

    public boolean isPersistent() {
        return this.delegate.isPersistent();
    }

    public Path createTempFile(String prefix, String suffix) throws IOException {
        this.adversary.injectFailure(IOException.class, SecurityException.class);
        return this.delegate.createTempFile(prefix, suffix);
    }

    public Path createTempFile(Path dir, String prefix, String suffix) throws IOException {
        this.adversary.injectFailure(IOException.class, SecurityException.class);
        return this.delegate.createTempFile(dir, prefix, suffix);
    }

    public Path createTempDirectory(String prefix) throws IOException {
        this.adversary.injectFailure(IOException.class, SecurityException.class);
        return this.delegate.createTempDirectory(prefix);
    }

    public Path createTempDirectory(Path dir, String prefix) throws IOException {
        this.adversary.injectFailure(IOException.class, SecurityException.class);
        return this.delegate.createTempDirectory(dir, prefix);
    }

    public void close() throws IOException {
        this.adversary.injectFailure(IOException.class, SecurityException.class);
        this.delegate.close();
    }
}

