/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.StubPageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.monitoring.PageFileCounters;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.PageFileSwapperTracer;
import org.neo4j.io.pagecache.tracing.version.FileTruncateEvent;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

public class StubPagedFile
implements PagedFile {
    private final int pageSize;
    public final int exposedPageSize;
    private final int reservedBytes;
    public long lastPageId = 1L;

    public StubPagedFile(int pageSize, int reservedBytes) {
        this.pageSize = pageSize;
        this.exposedPageSize = pageSize;
        this.reservedBytes = reservedBytes;
    }

    public PageCursor io(long pageId, int pf_flags, CursorContext context) throws IOException {
        StubPageCursor cursor = new StubPageCursor(pageId, ByteBuffers.allocate((int)this.pageSize, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE), this.reservedBytes);
        this.prepareCursor(cursor);
        return cursor;
    }

    protected void prepareCursor(StubPageCursor cursor) {
    }

    public int pageSize() {
        return this.exposedPageSize;
    }

    public int payloadSize() {
        return this.pageSize - this.reservedBytes;
    }

    public int pageReservedBytes() {
        return this.reservedBytes;
    }

    public long fileSize() {
        if (this.lastPageId < 0L) {
            return 0L;
        }
        return (this.lastPageId + 1L) * (long)this.pageSize();
    }

    public Path path() {
        return Path.of("stub", new String[0]);
    }

    public void flushAndForce(FileFlushEvent flushEvent) {
    }

    public long getLastPageId() {
        return this.lastPageId;
    }

    public void increaseLastPageIdTo(long newLastPageId) {
    }

    public void close() {
    }

    public void setDeleteOnClose(boolean deleteOnClose) {
    }

    public boolean isDeleteOnClose() {
        return false;
    }

    public String getDatabaseName() {
        return "stub";
    }

    public PageFileCounters pageFileCounters() {
        return PageFileSwapperTracer.NULL;
    }

    public boolean isMultiVersioned() {
        return false;
    }

    public void truncate(long pagesToKeep, FileTruncateEvent truncateEvent) throws IOException {
    }

    public int touch(long pageId, int count, CursorContext cursorContext) {
        return 0;
    }

    public boolean preAllocateSupported() {
        return false;
    }

    public void preAllocate(long newFileSizeInPages) {
    }
}

