/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries.fs;

import java.io.IOException;
import java.io.InputStream;
import org.neo4j.adversaries.Adversary;

public class AdversarialInputStream
extends InputStream {
    private final InputStream inputStream;
    private final Adversary adversary;

    public AdversarialInputStream(InputStream inputStream, Adversary adversary) {
        this.inputStream = inputStream;
        this.adversary = adversary;
    }

    @Override
    public int read() throws IOException {
        this.adversary.injectFailure(IOException.class);
        return this.inputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class, NullPointerException.class)) {
            byte[] dup = new byte[Math.max(b.length / 2, 1)];
            int read = this.inputStream.read(dup);
            System.arraycopy(dup, 0, b, 0, read);
            return read;
        }
        return this.inputStream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class, NullPointerException.class, IndexOutOfBoundsException.class)) {
            int halflen = Math.max(len / 2, 1);
            return this.inputStream.read(b, off, halflen);
        }
        return this.inputStream.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        this.adversary.injectFailure(IOException.class, NullPointerException.class, IndexOutOfBoundsException.class);
        return this.inputStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        this.adversary.injectFailure(IOException.class);
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.adversary.injectFailure(IOException.class);
        this.inputStream.close();
    }

    @Override
    public void mark(int readlimit) {
        this.adversary.injectFailure(new Class[0]);
        this.inputStream.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.adversary.injectFailure(IOException.class);
        this.inputStream.reset();
    }

    @Override
    public boolean markSupported() {
        this.adversary.injectFailure(new Class[0]);
        return this.inputStream.markSupported();
    }
}

