/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.memory.MemoryTracker;

public class ChannelInputStream
extends InputStream {
    private final StoreChannel channel;
    private final ScopedBuffer scopedBuffer;
    private final ByteBuffer buffer;
    private int position;

    public ChannelInputStream(StoreChannel channel, MemoryTracker memoryTracker) {
        this.channel = channel;
        this.scopedBuffer = new HeapScopedBuffer(Math.toIntExact(ByteUnit.KibiByte.toBytes(8L)), ByteOrder.LITTLE_ENDIAN, memoryTracker);
        this.buffer = this.scopedBuffer.getBuffer();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.buffer.clear();
        this.buffer.limit(Math.min(len, this.buffer.capacity()));
        int totalRead = 0;
        boolean eof = false;
        while (this.buffer.hasRemaining() && !eof) {
            int bytesRead = this.channel.read(this.buffer);
            if (bytesRead < 0) {
                eof = true;
                if (totalRead != 0) continue;
                return -1;
            }
            totalRead += bytesRead;
        }
        this.buffer.flip();
        this.position += totalRead;
        this.buffer.get(b, off, totalRead);
        return totalRead;
    }

    @Override
    public int read() throws IOException {
        this.buffer.clear();
        this.buffer.limit(1);
        while (this.buffer.hasRemaining()) {
            int read = this.channel.read(this.buffer);
            if (read != -1) continue;
            return -1;
        }
        this.buffer.flip();
        ++this.position;
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int available() throws IOException {
        return (int)(this.channel.size() - (long)this.position);
    }

    @Override
    public void close() throws IOException {
        this.scopedBuffer.close();
        this.channel.close();
    }
}

