/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries.pagecache;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.pagecache.AdversarialPagedFile;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.buffer.IOBufferFactory;
import org.neo4j.io.pagecache.impl.muninn.EvictionBouncer;
import org.neo4j.io.pagecache.impl.muninn.VersionStorage;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;

public class AdversarialPageCache
implements PageCache {
    private final PageCache delegate;
    private final Adversary adversary;

    public AdversarialPageCache(PageCache delegate, Adversary adversary) {
        this.delegate = Objects.requireNonNull(delegate);
        this.adversary = Objects.requireNonNull(adversary);
    }

    public PagedFile map(Path path, int pageSize, String databaseName, ImmutableSet<OpenOption> openOptions, IOController ioController, EvictionBouncer evictionBouncer, VersionStorage versionStorage) throws IOException {
        if (openOptions.contains((Object)StandardOpenOption.CREATE)) {
            this.adversary.injectFailure(IOException.class, SecurityException.class);
        } else {
            this.adversary.injectFailure(NoSuchFileException.class, IOException.class, SecurityException.class);
        }
        PagedFile pagedFile = this.delegate.map(path, pageSize, databaseName, openOptions, ioController, evictionBouncer, versionStorage);
        return new AdversarialPagedFile(pagedFile, this.adversary);
    }

    public Optional<PagedFile> getExistingMapping(Path path) throws IOException {
        this.adversary.injectFailure(IOException.class, SecurityException.class);
        Optional optional = this.delegate.getExistingMapping(path);
        return optional.map(pagedFile -> new AdversarialPagedFile((PagedFile)pagedFile, this.adversary));
    }

    public List<PagedFile> listExistingMappings() throws IOException {
        this.adversary.injectFailure(IOException.class, SecurityException.class);
        return this.delegate.listExistingMappings().stream().map(file -> new AdversarialPagedFile((PagedFile)file, this.adversary)).map(PagedFile.class::cast).toList();
    }

    public void flushAndForce(DatabaseFlushEvent flushEvent) throws IOException {
        this.adversary.injectFailure(NoSuchFileException.class, IOException.class, SecurityException.class);
        this.delegate.flushAndForce(flushEvent);
    }

    public void close() {
        this.adversary.injectFailure(IllegalStateException.class);
        this.delegate.close();
    }

    public int pageSize() {
        return this.delegate.pageSize();
    }

    public int pageReservedBytes(ImmutableSet<OpenOption> openOptions) {
        return this.delegate.pageReservedBytes(openOptions);
    }

    public long maxCachedPages() {
        return this.delegate.maxCachedPages();
    }

    public IOBufferFactory getBufferFactory() {
        return this.delegate.getBufferFactory();
    }
}

