/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension.testdirectory;

import java.io.IOException;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.platform.commons.JUnitException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.extension.FileSystemExtension;
import org.neo4j.test.extension.StatefulFieldExtension;
import org.neo4j.test.rule.TestDirectory;

public class TestDirectorySupportExtension
extends StatefulFieldExtension<TestDirectory>
implements BeforeEachCallback,
BeforeAllCallback,
AfterEachCallback,
AfterAllCallback,
TestExecutionExceptionHandler {
    public static final String TEST_DIRECTORY = "testDirectory";
    private static final String FAILURE_MARKER = "failureMarker";
    public static final ExtensionContext.Namespace TEST_DIRECTORY_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"testDirectory"});

    public void beforeAll(ExtensionContext context) throws IOException {
        if (TestDirectorySupportExtension.getLifecycle(context) == TestInstance.Lifecycle.PER_CLASS) {
            this.prepare(context);
        }
    }

    public void beforeEach(ExtensionContext context) throws IOException {
        if (TestDirectorySupportExtension.getLifecycle(context) == TestInstance.Lifecycle.PER_METHOD) {
            this.prepare(context);
        }
    }

    public void afterEach(ExtensionContext context) {
        if (TestDirectorySupportExtension.getLifecycle(context) == TestInstance.Lifecycle.PER_METHOD) {
            this.cleanUp(context);
        }
    }

    public void afterAll(ExtensionContext context) {
        if (TestDirectorySupportExtension.getLifecycle(context) == TestInstance.Lifecycle.PER_CLASS) {
            this.cleanUp(context);
        }
    }

    private static TestInstance.Lifecycle getLifecycle(ExtensionContext context) {
        return context.getTestInstanceLifecycle().orElse(TestInstance.Lifecycle.PER_METHOD);
    }

    public void prepare(ExtensionContext context) throws IOException {
        String name = context.getTestMethod().map(method -> method.getName().concat(context.getDisplayName())).orElseGet(() -> context.getRequiredTestClass().getSimpleName());
        TestDirectory testDirectory = (TestDirectory)((Object)this.getStoredValue(context));
        testDirectory.prepareDirectory(context.getRequiredTestClass(), name);
    }

    private void cleanUp(ExtensionContext context) {
        TestDirectory testDirectory = (TestDirectory)((Object)this.getStoredValue(context));
        try {
            testDirectory.complete(context.getExecutionException().isEmpty() && !this.hasFailureMarker(context));
        }
        catch (Exception e) {
            throw new JUnitException(String.format("Fail to cleanup test directory for %s test.", context.getDisplayName()), (Throwable)e);
        }
    }

    protected String getFieldKey() {
        return TEST_DIRECTORY;
    }

    protected Class<TestDirectory> getFieldType() {
        return TestDirectory.class;
    }

    protected TestDirectory createField(ExtensionContext extensionContext) {
        ExtensionContext.Store fileSystemStore = TestDirectorySupportExtension.getStore((ExtensionContext)extensionContext, (ExtensionContext.Namespace)FileSystemExtension.FILE_SYSTEM_NAMESPACE);
        FileSystemAbstraction fileSystemAbstraction = (FileSystemAbstraction)fileSystemStore.get((Object)"fileSystem", FileSystemAbstraction.class);
        return fileSystemAbstraction != null ? TestDirectory.testDirectory(fileSystemAbstraction) : TestDirectory.testDirectory();
    }

    protected ExtensionContext.Namespace getNameSpace() {
        return TEST_DIRECTORY_NAMESPACE;
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        if (TestDirectorySupportExtension.getLifecycle(context) == TestInstance.Lifecycle.PER_CLASS) {
            ExtensionContext.Store store = this.getTestDirectoryStore(context);
            store.put((Object)FAILURE_MARKER, (Object)Boolean.TRUE);
        }
        throw throwable;
    }

    private boolean hasFailureMarker(ExtensionContext context) {
        return TestDirectorySupportExtension.getLifecycle(context) == TestInstance.Lifecycle.PER_CLASS && this.getLocalStore(context).get((Object)FAILURE_MARKER) != null;
    }

    private ExtensionContext.Store getTestDirectoryStore(ExtensionContext context) {
        ExtensionContext.Store store = null;
        while (context != null) {
            ExtensionContext.Store localStore = context.getStore(this.getNameSpace());
            if (localStore.get((Object)this.getFieldKey()) == null) {
                return store;
            }
            store = localStore;
            context = context.getParent().orElse(null);
        }
        throw new IllegalStateException("Test directory store not found");
    }
}

