/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.neo4j.gds.utils.StringFormatting;

public final class StructuredOutputHelper {
    static final String UNKNOWN = "n/a";
    static final String TASK_BRANCH_TOKEN = "|-- ";
    static final String TASK_LEVEL_INDENTATION = "    ";

    private StructuredOutputHelper() {
    }

    static String progressBar(long progress, long volume, int progressBarLength) {
        if (volume == -1L) {
            return StringFormatting.formatWithLocale((String)"[~~~~%s~~~]", (Object[])new Object[]{UNKNOWN});
        }
        double percentage = volume == 0L ? 100.0 : (double)progress / ((double)volume / 100.0);
        int scaledPercentage = (int)(percentage / 100.0 * (double)progressBarLength);
        String filledProgressBar = "#".repeat(scaledPercentage);
        String remainingProgressBar = "~".repeat(progressBarLength - scaledPercentage);
        String progressBarContent = filledProgressBar + remainingProgressBar;
        return StringFormatting.formatWithLocale((String)"[%s]", (Object[])new Object[]{progressBarContent});
    }

    public static String computeProgress(long progress, long volume) {
        if (volume == -1L) {
            return UNKNOWN;
        }
        double progressPercentage = volume == 0L ? 1.0 : (double)progress / (double)volume;
        DecimalFormat decimalFormat = new DecimalFormat("###.##%", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        return decimalFormat.format(progressPercentage);
    }

    static String treeViewDescription(String description, int depth) {
        return TASK_LEVEL_INDENTATION.repeat(depth) + TASK_BRANCH_TOKEN + description;
    }
}

