/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.stream.Stream;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.StreamOfRelationshipsWriter;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.config.WriteRelationshipConfig;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.write.RelationshipStreamExporter;
import org.neo4j.gds.core.write.RelationshipStreaming;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.logging.Log;

public abstract class WriteStreamOfRelationshipsProc<ALGO extends Algorithm<ALGO_RESULT>, ALGO_RESULT extends RelationshipStreaming, PROC_RESULT, CONFIG extends WriteRelationshipConfig & WritePropertyConfig>
extends StreamOfRelationshipsWriter<ALGO, ALGO_RESULT, CONFIG, PROC_RESULT> {
    protected abstract AbstractResultBuilder<PROC_RESULT> resultBuilder(ComputationResult<ALGO, ALGO_RESULT, CONFIG> var1);

    @Override
    protected NodeProperties nodeProperties(ComputationResult<ALGO, ALGO_RESULT, CONFIG> computationResult) {
        throw new UnsupportedOperationException("Write relationship procedures do not produce node properties.");
    }

    public ComputationResultConsumer<ALGO, ALGO_RESULT, CONFIG, Stream<PROC_RESULT>> computationResultConsumer() {
        return (computationResult, executionContext) -> this.runWithExceptionLogging("Graph write failed", () -> {
            WriteRelationshipConfig config = (WriteRelationshipConfig)computationResult.config();
            AbstractResultBuilder builder = this.resultBuilder(computationResult).withPreProcessingMillis(computationResult.preProcessingMillis()).withComputeMillis(computationResult.computeMillis()).withNodeCount(computationResult.graph().nodeCount()).withConfig((AlgoBaseConfig)config);
            if (!computationResult.isGraphEmpty()) {
                this.writeToNeo(builder, computationResult, executionContext);
                computationResult.graph().releaseProperties();
            }
            return Stream.of(builder.build());
        });
    }

    protected Stream<PROC_RESULT> write(ComputationResult<ALGO, ALGO_RESULT, CONFIG> computeResult) {
        return (Stream)this.computationResultConsumer().consume(computeResult, this.executionContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToNeo(AbstractResultBuilder<?> resultBuilder, ComputationResult<ALGO, ALGO_RESULT, CONFIG> computationResult, ExecutionContext executionContext) {
        WriteRelationshipConfig config = (WriteRelationshipConfig)computationResult.config();
        try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> resultBuilder.withWriteMillis(arg_0));){
            Log log = executionContext.log();
            log.debug("Writing results");
            Graph graph = computationResult.graph();
            TaskProgressTracker progressTracker = new TaskProgressTracker(RelationshipStreamExporter.baseTask((String)this.name()), log, ((WriteRelationshipConfig)computationResult.config()).writeConcurrency(), executionContext.taskRegistryFactory());
            long relationshipsWritten = 0L;
            try {
                relationshipsWritten = this.createRelationshipStreamExporter(graph, (ProgressTracker)progressTracker, computationResult).write(config.writeRelationshipType(), new String[]{((WritePropertyConfig)config).writeProperty()});
            }
            finally {
                progressTracker.release();
            }
            resultBuilder.withRelationshipsWritten(relationshipsWritten);
        }
    }

    private RelationshipStreamExporter createRelationshipStreamExporter(Graph graph, ProgressTracker progressTracker, ComputationResult<ALGO, ALGO_RESULT, CONFIG> computationResult) {
        return this.relationshipStreamExporterBuilder.withIdMappingOperator(arg_0 -> ((Graph)graph).toOriginalNodeId(arg_0)).withTerminationFlag(computationResult.algorithm().terminationFlag).withRelationships(((RelationshipStreaming)computationResult.result()).relationshipStream()).withProgressTracker(progressTracker).build();
    }
}

