/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.ProcPreconditions;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.AlgoConfigParser;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutorSpec;
import org.neo4j.gds.executor.GraphCreationFactory;
import org.neo4j.gds.executor.GraphStoreFromCatalogLoader;
import org.neo4j.gds.executor.MemoryEstimationExecutor;
import org.neo4j.gds.executor.MemoryUsageValidator;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.executor.ProcConfigParser;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.executor.ProcedureExecutorSpec;
import org.neo4j.gds.executor.ProcedureGraphCreationFactory;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.executor.validation.Validator;
import org.neo4j.gds.results.MemoryEstimateResult;

public abstract class AlgoBaseProc<ALGO extends Algorithm<ALGO_RESULT>, ALGO_RESULT, CONFIG extends AlgoBaseConfig, PROC_RESULT>
extends BaseProc
implements AlgorithmSpec<ALGO, ALGO_RESULT, CONFIG, Stream<PROC_RESULT>, AlgorithmFactory<?, ALGO, CONFIG>> {
    public static final String STATS_DESCRIPTION = "Executes the algorithm and returns result statistics without writing the result to Neo4j.";

    public ProcConfigParser<CONFIG> configParser() {
        return new AlgoConfigParser(this.username(), this::newConfig);
    }

    protected abstract CONFIG newConfig(String var1, CypherMapWrapper var2);

    protected ComputationResult<ALGO, ALGO_RESULT, CONFIG> compute(String graphName, Map<String, Object> configuration) {
        ProcPreconditions.check();
        return this.compute(graphName, configuration, true, true);
    }

    protected ComputationResult<ALGO, ALGO_RESULT, CONFIG> compute(String graphName, Map<String, Object> configuration, boolean releaseAlgorithm, boolean releaseTopology) {
        return (ComputationResult)this.procedureExecutor().compute(graphName, configuration, releaseAlgorithm, releaseTopology);
    }

    protected NodeProperties nodeProperties(ComputationResult<ALGO, ALGO_RESULT, CONFIG> computationResult) {
        throw new UnsupportedOperationException("Procedure must implement org.neo4j.gds.AlgoBaseProc.nodeProperty");
    }

    protected Stream<MemoryEstimateResult> computeEstimate(Object graphNameOrConfiguration, Map<String, Object> algoConfiguration) {
        return new MemoryEstimationExecutor((AlgorithmSpec)this, (ExecutorSpec)new ProcedureExecutorSpec(), this.executionContext()).computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    public String name() {
        return this.getClass().getSimpleName();
    }

    public NewConfigFunction<CONFIG> newConfigFunction() {
        return this::newConfig;
    }

    public ValidationConfiguration<CONFIG> validationConfig() {
        return ValidationConfiguration.empty();
    }

    private ProcedureExecutor<ALGO, ALGO_RESULT, CONFIG, ComputationResult<ALGO, ALGO_RESULT, CONFIG>> procedureExecutor() {
        AlgoBaseExecutorSpec pipelineSpec = new AlgoBaseExecutorSpec();
        final String name = this.name();
        final AlgorithmFactory factory = this.algorithmFactory();
        final NewConfigFunction<CONFIG> configFunction = this.newConfigFunction();
        final ValidationConfiguration<CONFIG> validationConfig = this.validationConfig();
        AlgorithmSpec algoSpec = new AlgorithmSpec<ALGO, ALGO_RESULT, CONFIG, ComputationResult<ALGO, ALGO_RESULT, CONFIG>, AlgorithmFactory<?, ALGO, CONFIG>>(){

            public String name() {
                return name;
            }

            public AlgorithmFactory<?, ALGO, CONFIG> algorithmFactory() {
                return factory;
            }

            public NewConfigFunction<CONFIG> newConfigFunction() {
                return configFunction;
            }

            public ComputationResultConsumer<ALGO, ALGO_RESULT, CONFIG, ComputationResult<ALGO, ALGO_RESULT, CONFIG>> computationResultConsumer() {
                return ComputationResultConsumer.identity();
            }

            public ValidationConfiguration<CONFIG> validationConfig() {
                return validationConfig;
            }
        };
        return new ProcedureExecutor(algoSpec, (ExecutorSpec)pipelineSpec, this.executionContext());
    }

    private final class AlgoBaseExecutorSpec
    implements ExecutorSpec<ALGO, ALGO_RESULT, CONFIG> {
        private AlgoBaseExecutorSpec() {
        }

        public ProcConfigParser<CONFIG> configParser(NewConfigFunction<CONFIG> newConfigFunction, ExecutionContext executionContext) {
            return AlgoBaseProc.this.configParser();
        }

        public Validator<CONFIG> validator(ValidationConfiguration<CONFIG> validationConfiguration) {
            return new Validator(validationConfiguration);
        }

        public GraphCreationFactory<ALGO, ALGO_RESULT, CONFIG> graphCreationFactory(ExecutionContext executionContext) {
            return new ProcedureGraphCreationFactory((config, graphName) -> new GraphStoreFromCatalogLoader(graphName, config, executionContext.username(), executionContext.databaseId(), executionContext.isGdsAdmin()), new MemoryUsageValidator(executionContext.log(), executionContext.api()));
        }
    }
}

