/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.betweenness;

import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.WriteProc;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.betweenness.BetweennessCentrality;
import org.neo4j.gds.betweenness.BetweennessCentralityProc;
import org.neo4j.gds.betweenness.BetweennessCentralityStatsProc;
import org.neo4j.gds.betweenness.BetweennessCentralityWriteConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.paged.HugeAtomicDoubleArray;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.result.AbstractCentralityResultBuilder;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.betweenness.write", description="Betweenness centrality measures the relative information flow that passes through a node.", executionMode=ExecutionMode.WRITE_NODE_PROPERTY)
public class BetweennessCentralityWriteProc
extends WriteProc<BetweennessCentrality, HugeAtomicDoubleArray, WriteResult, BetweennessCentralityWriteConfig> {
    @Procedure(value="gds.betweenness.write", mode=Mode.WRITE)
    @Description(value="Betweenness centrality measures the relative information flow that passes through a node.")
    public Stream<WriteResult> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.write(this.compute(graphName, configuration));
    }

    @Procedure(value="gds.betweenness.write.estimate", mode=Mode.READ)
    @Description(value="Betweenness centrality measures the relative information flow that passes through a node.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected BetweennessCentralityWriteConfig newConfig(String username, CypherMapWrapper config) {
        return BetweennessCentralityWriteConfig.of((CypherMapWrapper)config);
    }

    public ValidationConfiguration<BetweennessCentralityWriteConfig> validationConfig() {
        return BetweennessCentralityProc.getValidationConfig();
    }

    public GraphAlgorithmFactory<BetweennessCentrality, BetweennessCentralityWriteConfig> algorithmFactory() {
        return BetweennessCentralityProc.algorithmFactory();
    }

    protected NodePropertyValues nodeProperties(ComputationResult<BetweennessCentrality, HugeAtomicDoubleArray, BetweennessCentralityWriteConfig> computationResult) {
        return BetweennessCentralityProc.nodeProperties(computationResult);
    }

    protected AbstractResultBuilder<WriteResult> resultBuilder(ComputationResult<BetweennessCentrality, HugeAtomicDoubleArray, BetweennessCentralityWriteConfig> computeResult, ExecutionContext executionContext) {
        return BetweennessCentralityProc.resultBuilder(new WriteResult.Builder(this.callContext, ((BetweennessCentralityWriteConfig)computeResult.config()).concurrency()), computeResult);
    }

    public static final class WriteResult
    extends BetweennessCentralityStatsProc.StatsResult {
        public final long nodePropertiesWritten;
        public final long writeMillis;

        WriteResult(long nodePropertiesWritten, long preProcessingMillis, long computeMillis, long postProcessingMillis, long writeMillis, @Nullable Map<String, Object> centralityDistribution, Map<String, Object> config) {
            super(centralityDistribution, preProcessingMillis, computeMillis, postProcessingMillis, config);
            this.nodePropertiesWritten = nodePropertiesWritten;
            this.writeMillis = writeMillis;
        }

        static final class Builder
        extends AbstractCentralityResultBuilder<WriteResult> {
            protected Builder(ProcedureCallContext callContext, int concurrency) {
                super(callContext, concurrency);
            }

            public WriteResult buildResult() {
                return new WriteResult(this.nodePropertiesWritten, this.preProcessingMillis, this.computeMillis, this.postProcessingMillis, this.writeMillis, this.centralityHistogram, this.config.toMap());
            }
        }
    }
}

