/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.betweenness;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.StreamProc;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.betweenness.BetweennessCentrality;
import org.neo4j.gds.betweenness.BetweennessCentralityProc;
import org.neo4j.gds.betweenness.BetweennessCentralityStreamConfig;
import org.neo4j.gds.common.CentralityStreamResult;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.paged.HugeAtomicDoubleArray;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.betweenness.stream", description="Betweenness centrality measures the relative information flow that passes through a node.", executionMode=ExecutionMode.STREAM)
public class BetweennessCentralityStreamProc
extends StreamProc<BetweennessCentrality, HugeAtomicDoubleArray, CentralityStreamResult, BetweennessCentralityStreamConfig> {
    @Procedure(value="gds.betweenness.stream", mode=Mode.READ)
    @Description(value="Betweenness centrality measures the relative information flow that passes through a node.")
    public Stream<CentralityStreamResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return this.stream(computationResult);
    }

    @Procedure(value="gds.betweenness.stream.estimate", mode=Mode.READ)
    @Description(value="Betweenness centrality measures the relative information flow that passes through a node.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected CentralityStreamResult streamResult(long originalNodeId, long internalNodeId, NodePropertyValues nodePropertyValues) {
        return new CentralityStreamResult(originalNodeId, nodePropertyValues.doubleValue(internalNodeId));
    }

    protected NodePropertyValues nodeProperties(ComputationResult<BetweennessCentrality, HugeAtomicDoubleArray, BetweennessCentralityStreamConfig> computationResult) {
        return BetweennessCentralityProc.nodeProperties(computationResult);
    }

    protected BetweennessCentralityStreamConfig newConfig(String username, CypherMapWrapper config) {
        return BetweennessCentralityStreamConfig.of((CypherMapWrapper)config);
    }

    public ValidationConfiguration<BetweennessCentralityStreamConfig> validationConfig() {
        return BetweennessCentralityProc.getValidationConfig();
    }

    public GraphAlgorithmFactory<BetweennessCentrality, BetweennessCentralityStreamConfig> algorithmFactory() {
        return BetweennessCentralityProc.algorithmFactory();
    }
}

