/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pagerank;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.pagerank.PageRankAlgorithm;
import org.neo4j.gds.pagerank.PageRankAlgorithmFactory;
import org.neo4j.gds.pagerank.PageRankStatsConfig;
import org.neo4j.gds.pagerank.PageRankStatsProc;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.articleRank.stats", description="Executes the algorithm and returns result statistics without writing the result to Neo4j.", executionMode=ExecutionMode.STATS)
public class ArticleRankStatsProc
extends PageRankStatsProc {
    @Override
    @Procedure(value="gds.articleRank.stats", mode=Mode.READ)
    @Description(value="Executes the algorithm and returns result statistics without writing the result to Neo4j.")
    public Stream<PageRankStatsProc.StatsResult> stats(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return super.stats(graphName, configuration);
    }

    @Override
    @Procedure(value="gds.articleRank.stats.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    @Override
    public GraphAlgorithmFactory<PageRankAlgorithm, PageRankStatsConfig> algorithmFactory() {
        return new PageRankAlgorithmFactory(PageRankAlgorithmFactory.Mode.ARTICLE_RANK);
    }
}

