/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.degree;

import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.MutatePropertyProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.degree.DegreeCentrality;
import org.neo4j.gds.degree.DegreeCentralityFactory;
import org.neo4j.gds.degree.DegreeCentralityMutateConfig;
import org.neo4j.gds.degree.DegreeCentralityProc;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.result.AbstractCentralityResultBuilder;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.results.StandardMutateResult;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.degree.mutate", description="Degree centrality measures the number of incoming and outgoing relationships from a node.", executionMode=ExecutionMode.MUTATE_NODE_PROPERTY)
public class DegreeCentralityMutateProc
extends MutatePropertyProc<DegreeCentrality, DegreeCentrality.DegreeFunction, MutateResult, DegreeCentralityMutateConfig> {
    @Procedure(value="gds.degree.mutate", mode=Mode.READ)
    @Description(value="Degree centrality measures the number of incoming and outgoing relationships from a node.")
    public Stream<MutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.mutate(this.compute(graphName, configuration));
    }

    @Procedure(value="gds.degree.mutate.estimate", mode=Mode.READ)
    @Description(value="Degree centrality measures the number of incoming and outgoing relationships from a node.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected DegreeCentralityMutateConfig newConfig(String username, CypherMapWrapper config) {
        return DegreeCentralityMutateConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<DegreeCentrality, DegreeCentralityMutateConfig> algorithmFactory() {
        return new DegreeCentralityFactory();
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(ComputationResult<DegreeCentrality, DegreeCentrality.DegreeFunction, DegreeCentralityMutateConfig> computeResult, ExecutionContext executionContext) {
        return DegreeCentralityProc.resultBuilder(new MutateResult.Builder(executionContext.callContext(), ((DegreeCentralityMutateConfig)computeResult.config()).concurrency()), computeResult);
    }

    protected NodeProperties nodeProperties(ComputationResult<DegreeCentrality, DegreeCentrality.DegreeFunction, DegreeCentralityMutateConfig> computationResult) {
        return DegreeCentralityProc.nodeProperties(computationResult);
    }

    public static final class MutateResult
    extends StandardMutateResult {
        public final long nodePropertiesWritten;
        public final Map<String, Object> centralityDistribution;

        MutateResult(long nodePropertiesWritten, long preProcessingMillis, long computeMillis, long postProcessingMillis, long mutateMillis, @Nullable Map<String, Object> centralityDistribution, Map<String, Object> config) {
            super(preProcessingMillis, computeMillis, postProcessingMillis, mutateMillis, config);
            this.nodePropertiesWritten = nodePropertiesWritten;
            this.centralityDistribution = centralityDistribution;
        }

        static final class Builder
        extends AbstractCentralityResultBuilder<MutateResult> {
            Builder(ProcedureCallContext context, int concurrency) {
                super(context, concurrency);
            }

            public MutateResult buildResult() {
                return new MutateResult(this.nodePropertiesWritten, this.preProcessingMillis, this.computeMillis, this.postProcessingMillis, this.mutateMillis, this.centralityHistogram, this.config.toMap());
            }
        }
    }
}

