/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.betweenness;

import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.MutatePropertyProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.betweenness.BetweennessCentrality;
import org.neo4j.gds.betweenness.BetweennessCentralityMutateConfig;
import org.neo4j.gds.betweenness.BetweennessCentralityProc;
import org.neo4j.gds.betweenness.BetweennessCentralityStatsProc;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.paged.HugeAtomicDoubleArray;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.result.AbstractCentralityResultBuilder;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.betweenness.mutate", description="Betweenness centrality measures the relative information flow that passes through a node.", executionMode=ExecutionMode.MUTATE_NODE_PROPERTY)
public class BetweennessCentralityMutateProc
extends MutatePropertyProc<BetweennessCentrality, HugeAtomicDoubleArray, MutateResult, BetweennessCentralityMutateConfig> {
    @Procedure(value="gds.betweenness.mutate", mode=Mode.READ)
    @Description(value="Betweenness centrality measures the relative information flow that passes through a node.")
    public Stream<MutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.mutate(this.compute(graphName, configuration));
    }

    @Procedure(value="gds.betweenness.mutate.estimate", mode=Mode.READ)
    @Description(value="Betweenness centrality measures the relative information flow that passes through a node.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected BetweennessCentralityMutateConfig newConfig(String username, CypherMapWrapper config) {
        return BetweennessCentralityMutateConfig.of((CypherMapWrapper)config);
    }

    public ValidationConfiguration<BetweennessCentralityMutateConfig> validationConfig() {
        return BetweennessCentralityProc.getValidationConfig();
    }

    public GraphAlgorithmFactory<BetweennessCentrality, BetweennessCentralityMutateConfig> algorithmFactory() {
        return BetweennessCentralityProc.algorithmFactory();
    }

    protected NodeProperties nodeProperties(ComputationResult<BetweennessCentrality, HugeAtomicDoubleArray, BetweennessCentralityMutateConfig> computationResult) {
        return BetweennessCentralityProc.nodeProperties(computationResult);
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(ComputationResult<BetweennessCentrality, HugeAtomicDoubleArray, BetweennessCentralityMutateConfig> computeResult, ExecutionContext executionContext) {
        return BetweennessCentralityProc.resultBuilder(new MutateResult.Builder(executionContext.callContext(), ((BetweennessCentralityMutateConfig)computeResult.config()).concurrency()), computeResult);
    }

    public static final class MutateResult
    extends BetweennessCentralityStatsProc.StatsResult {
        public final long nodePropertiesWritten;
        public final long mutateMillis;

        MutateResult(long nodePropertiesWritten, long preProcessingMillis, long computeMillis, long postProcessingMillis, long mutateMillis, @Nullable Map<String, Object> centralityDistribution, Map<String, Object> config) {
            super(centralityDistribution, preProcessingMillis, computeMillis, postProcessingMillis, config);
            this.nodePropertiesWritten = nodePropertiesWritten;
            this.mutateMillis = mutateMillis;
        }

        static final class Builder
        extends AbstractCentralityResultBuilder<MutateResult> {
            Builder(ProcedureCallContext context, int concurrency) {
                super(context, concurrency);
            }

            public MutateResult buildResult() {
                return new MutateResult(this.nodePropertiesWritten, this.preProcessingMillis, this.computeMillis, this.postProcessingMillis, this.mutateMillis, this.centralityHistogram, this.config.toMap());
            }
        }
    }
}

